/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core.policies;

import com.github.cassandra.jdbc.internal.datastax.driver.core.Cluster;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Statement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.WriteType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.DriverException;
import com.github.cassandra.jdbc.internal.datastax.driver.core.policies.RetryPolicy;
import com.github.cassandra.jdbc.internal.google.common.annotations.VisibleForTesting;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;

public class LoggingRetryPolicy
implements RetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(LoggingRetryPolicy.class);
    @VisibleForTesting
    static final String IGNORING_READ_TIMEOUT = "Ignoring read timeout (initial consistency: {}, required responses: {}, received responses: {}, data retrieved: {}, retries: {})";
    @VisibleForTesting
    static final String RETRYING_ON_READ_TIMEOUT = "Retrying on read timeout on {} at consistency {} (initial consistency: {}, required responses: {}, received responses: {}, data retrieved: {}, retries: {})";
    @VisibleForTesting
    static final String IGNORING_WRITE_TIMEOUT = "Ignoring write timeout (initial consistency: {}, write type: {}, required acknowledgments: {}, received acknowledgments: {}, retries: {})";
    @VisibleForTesting
    static final String RETRYING_ON_WRITE_TIMEOUT = "Retrying on write timeout on {} at consistency {} (initial consistency: {}, write type: {}, required acknowledgments: {}, received acknowledgments: {}, retries: {})";
    @VisibleForTesting
    static final String IGNORING_UNAVAILABLE = "Ignoring unavailable exception (initial consistency: {}, required replica: {}, alive replica: {}, retries: {})";
    @VisibleForTesting
    static final String RETRYING_ON_UNAVAILABLE = "Retrying on unavailable exception on {} at consistency {} (initial consistency: {}, required replica: {}, alive replica: {}, retries: {})";
    @VisibleForTesting
    static final String IGNORING_REQUEST_ERROR = "Ignoring request error (initial consistency: {}, retries: {}, exception: {})";
    @VisibleForTesting
    static final String RETRYING_ON_REQUEST_ERROR = "Retrying on request error on {} at consistency {} (initial consistency: {}, retries: {}, exception: {})";
    private final RetryPolicy policy;

    public LoggingRetryPolicy(RetryPolicy policy) {
        this.policy = policy;
    }

    private static ConsistencyLevel cl(ConsistencyLevel cl, RetryPolicy.RetryDecision decision) {
        return decision.getRetryConsistencyLevel() == null ? cl : decision.getRetryConsistencyLevel();
    }

    private static String host(RetryPolicy.RetryDecision decision) {
        return decision.isRetryCurrent() ? "same host" : "next host";
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        RetryPolicy.RetryDecision decision = this.policy.onReadTimeout(statement, cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry);
        switch (decision.getType()) {
            case IGNORE: {
                this.logDecision(IGNORING_READ_TIMEOUT, new Object[]{cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry});
                break;
            }
            case RETRY: {
                this.logDecision(RETRYING_ON_READ_TIMEOUT, new Object[]{LoggingRetryPolicy.host(decision), LoggingRetryPolicy.cl(cl, decision), cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry});
            }
        }
        return decision;
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        RetryPolicy.RetryDecision decision = this.policy.onWriteTimeout(statement, cl, writeType, requiredAcks, receivedAcks, nbRetry);
        switch (decision.getType()) {
            case IGNORE: {
                this.logDecision(IGNORING_WRITE_TIMEOUT, new Object[]{cl, writeType, requiredAcks, receivedAcks, nbRetry});
                break;
            }
            case RETRY: {
                this.logDecision(RETRYING_ON_WRITE_TIMEOUT, new Object[]{LoggingRetryPolicy.host(decision), LoggingRetryPolicy.cl(cl, decision), cl, writeType, requiredAcks, receivedAcks, nbRetry});
            }
        }
        return decision;
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        RetryPolicy.RetryDecision decision = this.policy.onUnavailable(statement, cl, requiredReplica, aliveReplica, nbRetry);
        switch (decision.getType()) {
            case IGNORE: {
                this.logDecision(IGNORING_UNAVAILABLE, new Object[]{cl, requiredReplica, aliveReplica, nbRetry});
                break;
            }
            case RETRY: {
                this.logDecision(RETRYING_ON_UNAVAILABLE, new Object[]{LoggingRetryPolicy.host(decision), LoggingRetryPolicy.cl(cl, decision), cl, requiredReplica, aliveReplica, nbRetry});
            }
        }
        return decision;
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
        RetryPolicy.RetryDecision decision = this.policy.onRequestError(statement, cl, e, nbRetry);
        switch (decision.getType()) {
            case IGNORE: {
                this.logDecision(IGNORING_REQUEST_ERROR, new Object[]{cl, nbRetry, e});
                break;
            }
            case RETRY: {
                this.logDecision(RETRYING_ON_REQUEST_ERROR, new Object[]{LoggingRetryPolicy.host(decision), LoggingRetryPolicy.cl(cl, decision), cl, nbRetry, e});
            }
        }
        return decision;
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
        this.policy.close();
    }

    protected void logDecision(String template, Object ... parameters) {
        logger.info(template, parameters);
    }
}

