/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions;

import com.github.cassandra.jdbc.internal.datastax.driver.core.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.QueryConsistencyException;
import java.net.InetSocketAddress;

public class ReadTimeoutException
extends QueryConsistencyException {
    private static final long serialVersionUID = 0L;
    private final boolean dataPresent;

    public ReadTimeoutException(ConsistencyLevel consistency, int received, int required, boolean dataPresent) {
        this(null, consistency, received, required, dataPresent);
    }

    public ReadTimeoutException(InetSocketAddress address, ConsistencyLevel consistency, int received, int required, boolean dataPresent) {
        super(address, String.format("Cassandra timeout during read query at consistency %s (%s)", new Object[]{consistency, ReadTimeoutException.formatDetails(received, required, dataPresent)}), consistency, received, required);
        this.dataPresent = dataPresent;
    }

    private ReadTimeoutException(InetSocketAddress address, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required, boolean dataPresent) {
        super(address, msg, cause, consistency, received, required);
        this.dataPresent = dataPresent;
    }

    private static String formatDetails(int received, int required, boolean dataPresent) {
        if (received < required) {
            return String.format("%d responses were required but only %d replica responded", required, received);
        }
        if (!dataPresent) {
            return "the replica queried for data didn't respond";
        }
        return "timeout while waiting for repair of inconsistent replica";
    }

    public boolean wasDataRetrieved() {
        return this.dataPresent;
    }

    @Override
    public ReadTimeoutException copy() {
        return new ReadTimeoutException(this.getAddress(), this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.wasDataRetrieved());
    }

    public ReadTimeoutException copy(InetSocketAddress address) {
        return new ReadTimeoutException(address, this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.wasDataRetrieved());
    }
}

