/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions;

import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.CoordinatorException;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.DriverException;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.QueryValidationException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class AlreadyExistsException
extends QueryValidationException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;
    private final String keyspace;
    private final String table;

    public AlreadyExistsException(String keyspace, String table) {
        this(null, keyspace, table);
    }

    public AlreadyExistsException(InetSocketAddress address, String keyspace, String table) {
        super(AlreadyExistsException.makeMsg(keyspace, table));
        this.address = address;
        this.keyspace = keyspace;
        this.table = table;
    }

    private AlreadyExistsException(InetSocketAddress address, String msg, Throwable cause, String keyspace, String table) {
        super(msg, cause);
        this.address = address;
        this.keyspace = keyspace;
        this.table = table;
    }

    private static String makeMsg(String keyspace, String table) {
        if (table.isEmpty()) {
            return String.format("Keyspace %s already exists", keyspace);
        }
        return String.format("Table %s.%s already exists", keyspace, table);
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean wasTableCreation() {
        return !this.table.isEmpty();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.table.isEmpty() ? null : this.table;
    }

    @Override
    public DriverException copy() {
        return new AlreadyExistsException(this.getAddress(), this.getMessage(), this, this.keyspace, this.table);
    }

    public AlreadyExistsException copy(InetSocketAddress address) {
        return new AlreadyExistsException(address, this.getMessage(), this, this.keyspace, this.table);
    }
}

