/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core;

import com.github.cassandra.jdbc.internal.datastax.driver.core.Row;
import com.github.cassandra.jdbc.internal.datastax.driver.core.SimpleJSONParser;
import com.github.cassandra.jdbc.internal.datastax.driver.core.VersionNumber;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;

public class TableOptionsMetadata {
    private static final String COMMENT = "comment";
    private static final String READ_REPAIR = "read_repair_chance";
    private static final String DCLOCAL_READ_REPAIR = "dclocal_read_repair_chance";
    private static final String LOCAL_READ_REPAIR = "local_read_repair_chance";
    private static final String REPLICATE_ON_WRITE = "replicate_on_write";
    private static final String GC_GRACE = "gc_grace_seconds";
    private static final String BF_FP_CHANCE = "bloom_filter_fp_chance";
    private static final String CACHING = "caching";
    private static final String COMPACTION = "compaction";
    private static final String COMPACTION_CLASS = "compaction_strategy_class";
    private static final String COMPACTION_OPTIONS = "compaction_strategy_options";
    private static final String POPULATE_CACHE_ON_FLUSH = "populate_io_cache_on_flush";
    private static final String COMPRESSION = "compression";
    private static final String COMPRESSION_PARAMS = "compression_parameters";
    private static final String MEMTABLE_FLUSH_PERIOD_MS = "memtable_flush_period_in_ms";
    private static final String DEFAULT_TTL = "default_time_to_live";
    private static final String SPECULATIVE_RETRY = "speculative_retry";
    private static final String INDEX_INTERVAL = "index_interval";
    private static final String MIN_INDEX_INTERVAL = "min_index_interval";
    private static final String MAX_INDEX_INTERVAL = "max_index_interval";
    private static final String CRC_CHECK_CHANCE = "crc_check_chance";
    private static final String EXTENSIONS = "extensions";
    private static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
    private static final double DEFAULT_BF_FP_CHANCE = 0.01;
    private static final boolean DEFAULT_POPULATE_CACHE_ON_FLUSH = false;
    private static final int DEFAULT_MEMTABLE_FLUSH_PERIOD = 0;
    private static final int DEFAULT_DEFAULT_TTL = 0;
    private static final String DEFAULT_SPECULATIVE_RETRY = "NONE";
    private static final int DEFAULT_INDEX_INTERVAL = 128;
    private static final int DEFAULT_MIN_INDEX_INTERVAL = 128;
    private static final int DEFAULT_MAX_INDEX_INTERVAL = 2048;
    private static final double DEFAULT_CRC_CHECK_CHANCE = 1.0;
    private final boolean isCompactStorage;
    private final String comment;
    private final double readRepair;
    private final double localReadRepair;
    private final boolean replicateOnWrite;
    private final int gcGrace;
    private final double bfFpChance;
    private final Map<String, String> caching;
    private final boolean populateCacheOnFlush;
    private final int memtableFlushPeriodMs;
    private final int defaultTTL;
    private final String speculativeRetry;
    private final Integer indexInterval;
    private final Integer minIndexInterval;
    private final Integer maxIndexInterval;
    private final Map<String, String> compaction;
    private final Map<String, String> compression;
    private final Double crcCheckChance;
    private final Map<String, ByteBuffer> extensions;

    TableOptionsMetadata(Row row, boolean isCompactStorage, VersionNumber version) {
        boolean is120 = version.getMajor() < 2;
        boolean is200 = version.getMajor() == 2 && version.getMinor() == 0;
        boolean is210 = version.getMajor() == 2 && version.getMinor() >= 1;
        boolean is300OrHigher = version.getMajor() > 2;
        boolean is210OrHigher = is210 || is300OrHigher;
        this.isCompactStorage = isCompactStorage;
        this.comment = TableOptionsMetadata.isNullOrAbsent(row, COMMENT) ? "" : row.getString(COMMENT);
        this.readRepair = row.getDouble(READ_REPAIR);
        this.localReadRepair = is300OrHigher ? row.getDouble(DCLOCAL_READ_REPAIR) : row.getDouble(LOCAL_READ_REPAIR);
        this.replicateOnWrite = is210OrHigher || TableOptionsMetadata.isNullOrAbsent(row, REPLICATE_ON_WRITE) ? true : row.getBool(REPLICATE_ON_WRITE);
        this.gcGrace = row.getInt(GC_GRACE);
        this.bfFpChance = TableOptionsMetadata.isNullOrAbsent(row, BF_FP_CHANCE) ? 0.01 : row.getDouble(BF_FP_CHANCE);
        this.populateCacheOnFlush = TableOptionsMetadata.isNullOrAbsent(row, POPULATE_CACHE_ON_FLUSH) ? false : row.getBool(POPULATE_CACHE_ON_FLUSH);
        this.memtableFlushPeriodMs = is120 || TableOptionsMetadata.isNullOrAbsent(row, MEMTABLE_FLUSH_PERIOD_MS) ? 0 : row.getInt(MEMTABLE_FLUSH_PERIOD_MS);
        this.defaultTTL = is120 || TableOptionsMetadata.isNullOrAbsent(row, DEFAULT_TTL) ? 0 : row.getInt(DEFAULT_TTL);
        String string = this.speculativeRetry = is120 || TableOptionsMetadata.isNullOrAbsent(row, SPECULATIVE_RETRY) ? DEFAULT_SPECULATIVE_RETRY : row.getString(SPECULATIVE_RETRY);
        this.indexInterval = is200 ? Integer.valueOf(TableOptionsMetadata.isNullOrAbsent(row, INDEX_INTERVAL) ? 128 : row.getInt(INDEX_INTERVAL)) : null;
        if (is210OrHigher) {
            this.minIndexInterval = TableOptionsMetadata.isNullOrAbsent(row, MIN_INDEX_INTERVAL) ? 128 : row.getInt(MIN_INDEX_INTERVAL);
            this.maxIndexInterval = TableOptionsMetadata.isNullOrAbsent(row, MAX_INDEX_INTERVAL) ? 2048 : row.getInt(MAX_INDEX_INTERVAL);
        } else {
            this.minIndexInterval = null;
            this.maxIndexInterval = null;
        }
        this.caching = is300OrHigher ? ImmutableMap.copyOf(row.getMap(CACHING, String.class, String.class)) : (is210 ? ImmutableMap.copyOf(SimpleJSONParser.parseStringMap(row.getString(CACHING))) : ImmutableMap.of("keys", row.getString(CACHING)));
        this.compaction = is300OrHigher ? ImmutableMap.copyOf(row.getMap(COMPACTION, String.class, String.class)) : ImmutableMap.builder().put("class", row.getString(COMPACTION_CLASS)).putAll(SimpleJSONParser.parseStringMap(row.getString(COMPACTION_OPTIONS))).build();
        this.compression = is300OrHigher ? ImmutableMap.copyOf(row.getMap(COMPRESSION, String.class, String.class)) : ImmutableMap.copyOf(SimpleJSONParser.parseStringMap(row.getString(COMPRESSION_PARAMS)));
        this.crcCheckChance = is300OrHigher ? Double.valueOf(TableOptionsMetadata.isNullOrAbsent(row, CRC_CHECK_CHANCE) ? 1.0 : row.getDouble(CRC_CHECK_CHANCE)) : null;
        this.extensions = is300OrHigher ? ImmutableMap.copyOf(row.getMap(EXTENSIONS, String.class, ByteBuffer.class)) : ImmutableMap.of();
    }

    private static boolean isNullOrAbsent(Row row, String name) {
        return row.getColumnDefinitions().getIndexOf(name) < 0 || row.isNull(name);
    }

    public boolean isCompactStorage() {
        return this.isCompactStorage;
    }

    public String getComment() {
        return this.comment;
    }

    public double getReadRepairChance() {
        return this.readRepair;
    }

    public double getLocalReadRepairChance() {
        return this.localReadRepair;
    }

    public boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public int getGcGraceInSeconds() {
        return this.gcGrace;
    }

    public double getBloomFilterFalsePositiveChance() {
        return this.bfFpChance;
    }

    public Map<String, String> getCaching() {
        return this.caching;
    }

    public boolean getPopulateIOCacheOnFlush() {
        return this.populateCacheOnFlush;
    }

    public int getMemtableFlushPeriodInMs() {
        return this.memtableFlushPeriodMs;
    }

    public int getDefaultTimeToLive() {
        return this.defaultTTL;
    }

    public String getSpeculativeRetry() {
        return this.speculativeRetry;
    }

    public Integer getIndexInterval() {
        return this.indexInterval;
    }

    public Integer getMinIndexInterval() {
        return this.minIndexInterval;
    }

    public Integer getMaxIndexInterval() {
        return this.maxIndexInterval;
    }

    public Double getCrcCheckChance() {
        return this.crcCheckChance;
    }

    public Map<String, String> getCompaction() {
        return this.compaction;
    }

    public Map<String, String> getCompression() {
        return this.compression;
    }

    public Map<String, ByteBuffer> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableOptionsMetadata)) {
            return false;
        }
        TableOptionsMetadata that = (TableOptionsMetadata)other;
        return this.isCompactStorage == that.isCompactStorage && Objects.equal(this.comment, that.comment) && this.readRepair == that.readRepair && this.localReadRepair == that.localReadRepair && this.replicateOnWrite == that.replicateOnWrite && this.gcGrace == that.gcGrace && this.bfFpChance == that.bfFpChance && Objects.equal(this.caching, that.caching) && this.populateCacheOnFlush == that.populateCacheOnFlush && this.memtableFlushPeriodMs == that.memtableFlushPeriodMs && this.defaultTTL == that.defaultTTL && Objects.equal(this.speculativeRetry, that.speculativeRetry) && Objects.equal(this.indexInterval, that.indexInterval) && Objects.equal(this.minIndexInterval, that.minIndexInterval) && Objects.equal(this.maxIndexInterval, that.maxIndexInterval) && Objects.equal(this.compaction, that.compaction) && Objects.equal(this.compression, that.compression) && Objects.equal(this.crcCheckChance, that.crcCheckChance) && Objects.equal(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hashCode(this.isCompactStorage, this.comment, this.readRepair, this.localReadRepair, this.replicateOnWrite, this.gcGrace, this.bfFpChance, this.caching, this.populateCacheOnFlush, this.memtableFlushPeriodMs, this.defaultTTL, this.speculativeRetry, this.indexInterval, this.minIndexInterval, this.maxIndexInterval, this.compaction, this.compression, this.crcCheckChance, this.extensions);
    }
}

