/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core;

import com.github.cassandra.jdbc.internal.datastax.driver.core.NettyUtil;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.bootstrap.Bootstrap;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.PooledByteBufAllocator;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelOption;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.EventLoopGroup;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.socket.SocketChannel;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.util.HashedWheelTimer;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.util.Timer;
import java.util.concurrent.ThreadFactory;

public class NettyOptions {
    public static final NettyOptions DEFAULT_INSTANCE = new NettyOptions();

    public EventLoopGroup eventLoopGroup(ThreadFactory threadFactory) {
        return NettyUtil.newEventLoopGroupInstance(threadFactory);
    }

    public Class<? extends SocketChannel> channelClass() {
        return NettyUtil.channelClass();
    }

    public void afterBootstrapInitialized(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
    }

    public void afterChannelInitialized(SocketChannel channel) throws Exception {
    }

    public void onClusterClose(EventLoopGroup eventLoopGroup) {
        eventLoopGroup.shutdownGracefully().syncUninterruptibly();
    }

    public Timer timer(ThreadFactory threadFactory) {
        return new HashedWheelTimer(threadFactory);
    }

    public void onClusterClose(Timer timer) {
        timer.stop();
    }
}

