/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core;

import com.github.cassandra.jdbc.internal.datastax.driver.core.SSLOptions;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.socket.SocketChannel;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.ssl.SslHandler;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class JdkSSLOptions
implements SSLOptions {
    private final SSLContext context;
    private final String[] cipherSuites;

    public static Builder builder() {
        return new Builder();
    }

    protected JdkSSLOptions(SSLContext context, String[] cipherSuites) {
        this.context = context == null ? JdkSSLOptions.makeDefaultContext() : context;
        this.cipherSuites = cipherSuites;
    }

    @Override
    public SslHandler newSSLHandler(SocketChannel channel) {
        SSLEngine engine = this.newSSLEngine(channel);
        return new SslHandler(engine);
    }

    protected SSLEngine newSSLEngine(SocketChannel channel) {
        SSLEngine engine = this.context.createSSLEngine();
        engine.setUseClientMode(true);
        if (this.cipherSuites != null) {
            engine.setEnabledCipherSuites(this.cipherSuites);
        }
        return engine;
    }

    private static SSLContext makeDefaultContext() throws IllegalStateException {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot initialize SSL Context", e);
        }
    }

    public static class Builder {
        private SSLContext context;
        private String[] cipherSuites;

        public Builder withSSLContext(SSLContext context) {
            this.context = context;
            return this;
        }

        public Builder withCipherSuites(String[] cipherSuites) {
            this.cipherSuites = cipherSuites;
            return this;
        }

        public JdkSSLOptions build() {
            return new JdkSSLOptions(this.context, this.cipherSuites);
        }
    }
}

