/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core;

import com.github.cassandra.jdbc.internal.datastax.driver.core.ColumnMetadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Metadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Row;
import com.github.cassandra.jdbc.internal.datastax.driver.core.SimpleJSONParser;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TableMetadata;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;
import com.github.cassandra.jdbc.internal.google.common.base.Predicate;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableMap;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;

public class IndexMetadata {
    static final String NAME = "index_name";
    static final String KIND = "kind";
    static final String OPTIONS = "options";
    public static final String TARGET_OPTION_NAME = "target";
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    public static final String INDEX_KEYS_OPTION_NAME = "index_keys";
    public static final String INDEX_ENTRIES_OPTION_NAME = "index_keys_and_values";
    private final TableMetadata table;
    private final String name;
    private final Kind kind;
    private final String target;
    private final Map<String, String> options;

    private IndexMetadata(TableMetadata table, String name, Kind kind, String target, Map<String, String> options) {
        this.table = table;
        this.name = name;
        this.kind = kind;
        this.target = target;
        this.options = options;
    }

    static IndexMetadata fromRow(TableMetadata table, Row indexRow) {
        String name = indexRow.getString(NAME);
        Kind kind = Kind.valueOf(indexRow.getString(KIND));
        Map<String, String> options = indexRow.getMap(OPTIONS, String.class, String.class);
        String target = options.get(TARGET_OPTION_NAME);
        return new IndexMetadata(table, name, kind, target, options);
    }

    static IndexMetadata fromLegacy(ColumnMetadata column, ColumnMetadata.Raw raw) {
        Map<String, String> indexColumns = raw.indexColumns;
        if (indexColumns.isEmpty()) {
            return null;
        }
        String type = indexColumns.get("index_type");
        if (type == null) {
            return null;
        }
        String indexName = indexColumns.get(NAME);
        String kindStr = indexColumns.get("index_type");
        Kind kind = kindStr == null ? null : Kind.valueOf(kindStr);
        String indexOptionsCol = indexColumns.get("index_options");
        Map<String, String> options = indexOptionsCol == null || indexOptionsCol.isEmpty() || indexOptionsCol.equals("null") ? ImmutableMap.of() : SimpleJSONParser.parseStringMap(indexOptionsCol);
        String target = IndexMetadata.targetFromLegacyOptions(column, options);
        return new IndexMetadata((TableMetadata)column.getParent(), indexName, kind, target, options);
    }

    private static String targetFromLegacyOptions(ColumnMetadata column, Map<String, String> options) {
        String columnName = Metadata.escapeId(column.getName());
        if (options.containsKey(INDEX_KEYS_OPTION_NAME)) {
            return String.format("keys(%s)", columnName);
        }
        if (options.containsKey(INDEX_ENTRIES_OPTION_NAME)) {
            return String.format("entries(%s)", columnName);
        }
        if (column.getType() instanceof DataType.CollectionType && column.getType().isFrozen()) {
            return String.format("full(%s)", columnName);
        }
        return columnName;
    }

    public TableMetadata getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isCustomIndex() {
        return this.getIndexClassName() != null;
    }

    public String getIndexClassName() {
        return this.getOption(CUSTOM_INDEX_OPTION_NAME);
    }

    public String getOption(String name) {
        return this.options != null ? this.options.get(name) : null;
    }

    public String asCQLQuery() {
        String keyspaceName = Metadata.escapeId(this.table.getKeyspace().getName());
        String tableName = Metadata.escapeId(this.table.getName());
        String indexName = Metadata.escapeId(this.name);
        return this.isCustomIndex() ? String.format("CREATE CUSTOM INDEX %s ON %s.%s (%s) USING '%s' %s;", indexName, keyspaceName, tableName, this.getTarget(), this.getIndexClassName(), this.getOptionsAsCql()) : String.format("CREATE INDEX %s ON %s.%s (%s);", indexName, keyspaceName, tableName, this.getTarget());
    }

    private String getOptionsAsCql() {
        Iterable<Map.Entry<String, String>> filtered = Iterables.filter(this.options.entrySet(), new Predicate<Map.Entry<String, String>>(){

            @Override
            public boolean apply(Map.Entry<String, String> input) {
                return !input.getKey().equals(IndexMetadata.TARGET_OPTION_NAME) && !input.getKey().equals(IndexMetadata.CUSTOM_INDEX_OPTION_NAME);
            }
        });
        if (Iterables.isEmpty(filtered)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("WITH OPTIONS = {");
        Iterator<Map.Entry<String, String>> it = filtered.iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> option = it.next();
            builder.append(String.format("'%s' : '%s'", option.getKey(), option.getValue()));
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.name, this.kind, this.target, this.options});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexMetadata)) {
            return false;
        }
        IndexMetadata other = (IndexMetadata)obj;
        return Objects.equal(this.name, other.name) && Objects.equal((Object)this.kind, (Object)other.kind) && Objects.equal(this.target, other.target) && Objects.equal(this.options, other.options);
    }

    public static enum Kind {
        KEYS,
        CUSTOM,
        COMPOSITES;

    }
}

