/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core;

import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.DriverInternalError;
import com.github.cassandra.jdbc.internal.google.common.base.Preconditions;
import com.github.cassandra.jdbc.internal.google.common.collect.HashMultimap;
import com.github.cassandra.jdbc.internal.google.common.collect.Lists;
import com.github.cassandra.jdbc.internal.google.common.collect.Maps;
import com.github.cassandra.jdbc.internal.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class DirectedGraph<V> {
    final Map<V, Integer> vertices;
    final Multimap<V, V> adjacencyList;
    boolean wasSorted;

    DirectedGraph(List<V> vertices) {
        this.vertices = Maps.newHashMapWithExpectedSize(vertices.size());
        this.adjacencyList = HashMultimap.create();
        for (V vertex : vertices) {
            this.vertices.put((Integer)vertex, 0);
        }
    }

    DirectedGraph(V ... vertices) {
        this(Arrays.asList(vertices));
    }

    void addEdge(V from, V to) {
        Preconditions.checkArgument(this.vertices.containsKey(from) && this.vertices.containsKey(to));
        this.adjacencyList.put(from, to);
        this.vertices.put((Integer)to, this.vertices.get(to) + 1);
    }

    List<V> topologicalSort() {
        Preconditions.checkState(!this.wasSorted);
        this.wasSorted = true;
        LinkedList<V> queue = new LinkedList<V>();
        for (Map.Entry<V, Integer> entry : this.vertices.entrySet()) {
            if (entry.getValue() != 0) continue;
            queue.add(entry.getKey());
        }
        ArrayList result = Lists.newArrayList();
        while (!queue.isEmpty()) {
            Object vertex = queue.remove();
            result.add(vertex);
            for (V successor : this.adjacencyList.get(vertex)) {
                if (this.decrementAndGetCount(successor) != 0) continue;
                queue.add(successor);
            }
        }
        if (result.size() != this.vertices.size()) {
            throw new DriverInternalError("failed to perform topological sort, graph has a cycle");
        }
        return result;
    }

    private int decrementAndGetCount(V vertex) {
        Integer count = this.vertices.get(vertex);
        count = count - 1;
        this.vertices.put((Integer)vertex, count);
        return count;
    }
}

