/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DriverThrowables;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ResultSet;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ResultSetFuture;
import com.github.cassandra.jdbc.internal.google.common.util.concurrent.AbstractFuture;
import com.github.cassandra.jdbc.internal.google.common.util.concurrent.FutureCallback;
import com.github.cassandra.jdbc.internal.google.common.util.concurrent.Futures;
import com.github.cassandra.jdbc.internal.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ChainedResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture {
    private volatile ResultSetFuture source;

    ChainedResultSetFuture() {
    }

    void setSource(ResultSetFuture source) {
        if (this.isCancelled()) {
            source.cancel(false);
        }
        this.source = source;
        Futures.addCallback(source, new FutureCallback<ResultSet>(){

            @Override
            public void onSuccess(ResultSet result) {
                ChainedResultSetFuture.this.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                ChainedResultSetFuture.this.setException(t);
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.source == null || this.source.cancel(mayInterruptIfRunning)) && super.cancel(mayInterruptIfRunning);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }
}

