/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;

public final class WindowsTimer {
    private static final Logger logger = LoggerFactory.getLogger(WindowsTimer.class);

    private static native int timeBeginPeriod(int var0) throws LastErrorException;

    private static native int timeEndPeriod(int var0) throws LastErrorException;

    private WindowsTimer() {
    }

    public static void startTimerPeriod(int period) {
        if (period == 0) {
            return;
        }
        assert (period > 0);
        if (WindowsTimer.timeBeginPeriod(period) != 0) {
            logger.warn("Failed to set timer to : " + period + ". Performance will be degraded.");
        }
    }

    public static void endTimerPeriod(int period) {
        if (period == 0) {
            return;
        }
        assert (period > 0);
        if (WindowsTimer.timeEndPeriod(period) != 0) {
            logger.warn("Failed to end accelerated timer period. System timer will remain set to: " + period + " ms.");
        }
    }

    static {
        try {
            Native.register((String)"winmm");
        }
        catch (Exception e) {
            logger.error("Failed to register winmm.dll. Performance will be negatively impacted on this node.");
        }
    }
}

