/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.github.cassandra.jdbc.internal.cassandra.db.TypeSizes;
import com.github.cassandra.jdbc.internal.cassandra.io.IVersionedSerializer;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataInputPlus;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataOutputPlus;
import java.io.IOException;
import java.util.UUID;

public class UUIDSerializer
implements IVersionedSerializer<UUID> {
    public static UUIDSerializer serializer = new UUIDSerializer();

    public void serialize(UUID uuid, DataOutputPlus out, int version) throws IOException {
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
    }

    public UUID deserialize(DataInputPlus in, int version) throws IOException {
        return new UUID(in.readLong(), in.readLong());
    }

    public long serializedSize(UUID uuid, int version) {
        return TypeSizes.sizeof((long)uuid.getMostSignificantBits()) + TypeSizes.sizeof((long)uuid.getLeastSignificantBits());
    }
}

