/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.clearspring.analytics.stream.Counter;
import com.clearspring.analytics.stream.StreamSummary;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.github.cassandra.jdbc.internal.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import com.github.cassandra.jdbc.internal.cassandra.concurrent.NamedThreadFactory;
import com.github.cassandra.jdbc.internal.google.common.annotations.VisibleForTesting;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TopKSampler<T> {
    private static final Logger logger = LoggerFactory.getLogger(TopKSampler.class);
    private volatile boolean enabled = false;
    @VisibleForTesting
    static final ThreadPoolExecutor samplerExecutor = new JMXEnabledThreadPoolExecutor(1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new NamedThreadFactory("Sampler"), "internal");
    private StreamSummary<T> summary;
    @VisibleForTesting
    HyperLogLogPlus hll;

    public synchronized void beginSampling(int capacity) {
        if (!this.enabled) {
            this.summary = new StreamSummary(capacity);
            this.hll = new HyperLogLogPlus(14);
            this.enabled = true;
        }
    }

    public synchronized SamplerResult<T> finishSampling(int count) {
        List results = Collections.EMPTY_LIST;
        long cardinality = 0L;
        if (this.enabled) {
            this.enabled = false;
            results = this.summary.topK(count);
            cardinality = this.hll.cardinality();
        }
        return new SamplerResult(results, cardinality);
    }

    public void addSample(T item) {
        this.addSample(item, item.hashCode(), 1);
    }

    public void addSample(final T item, final long hash, final int value) {
        if (this.enabled) {
            final TopKSampler lock = this;
            samplerExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        if (TopKSampler.this.enabled) {
                            try {
                                TopKSampler.this.summary.offer(item, value);
                                TopKSampler.this.hll.offerHashed(hash);
                            }
                            catch (Exception e) {
                                logger.trace("Failure to offer sample", e);
                            }
                        }
                    }
                }
            });
        }
    }

    public static class SamplerResult<S>
    implements Serializable {
        public final List<Counter<S>> topK;
        public final long cardinality;

        public SamplerResult(List<Counter<S>> topK, long cardinality) {
            this.topK = topK;
            this.cardinality = cardinality;
        }
    }
}

