/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.github.cassandra.jdbc.internal.cassandra.cache.AutoSavingCache;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.db.ColumnFamilyStore;
import com.github.cassandra.jdbc.internal.cassandra.db.compaction.CompactionManager;
import com.github.cassandra.jdbc.internal.cassandra.metrics.ThreadPoolMetrics;
import com.github.cassandra.jdbc.internal.cassandra.net.MessagingService;
import com.github.cassandra.jdbc.internal.cassandra.service.CacheService;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;

public class StatusLogger {
    private static final Logger logger = LoggerFactory.getLogger(StatusLogger.class);

    /*
     * WARNING - void declaration
     */
    public static void log() {
        void var2_6;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        logger.info(String.format("%-25s%10s%10s%15s%10s%18s", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All Time Blocked"));
        for (Map.Entry entry : ThreadPoolMetrics.getJmxThreadPools((MBeanServerConnection)server).entries()) {
            logger.info(String.format("%-25s%10s%10s%15s%10s%18s%n", entry.getValue(), ThreadPoolMetrics.getJmxMetric((MBeanServerConnection)server, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)"ActiveTasks"), ThreadPoolMetrics.getJmxMetric((MBeanServerConnection)server, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)"PendingTasks"), ThreadPoolMetrics.getJmxMetric((MBeanServerConnection)server, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)"CompletedTasks"), ThreadPoolMetrics.getJmxMetric((MBeanServerConnection)server, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)"CurrentlyBlockedTasks"), ThreadPoolMetrics.getJmxMetric((MBeanServerConnection)server, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)"TotalBlockedTasks")));
        }
        logger.info(String.format("%-25s%10s%10s", "CompactionManager", CompactionManager.instance.getActiveCompactions(), CompactionManager.instance.getPendingTasks()));
        int pendingLargeMessages = 0;
        Iterator iterator = MessagingService.instance().getLargeMessagePendingTasks().values().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            pendingLargeMessages += n;
        }
        boolean bl = false;
        Iterator n = MessagingService.instance().getSmallMessagePendingTasks().values().iterator();
        while (n.hasNext()) {
            int n2 = (Integer)n.next();
            var2_6 += n2;
        }
        logger.info(String.format("%-25s%10s%10s", "MessagingService", "n/a", pendingLargeMessages + "/" + (int)var2_6));
        AutoSavingCache keyCache = CacheService.instance.keyCache;
        AutoSavingCache rowCache = CacheService.instance.rowCache;
        int keyCacheKeysToSave = DatabaseDescriptor.getKeyCacheKeysToSave();
        int rowCacheKeysToSave = DatabaseDescriptor.getRowCacheKeysToSave();
        logger.info(String.format("%-25s%10s%25s%25s", "Cache Type", "Size", "Capacity", "KeysToSave"));
        logger.info(String.format("%-25s%10s%25s%25s", "KeyCache", keyCache.weightedSize(), keyCache.getCapacity(), keyCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(keyCacheKeysToSave)));
        logger.info(String.format("%-25s%10s%25s%25s", "RowCache", rowCache.weightedSize(), rowCache.getCapacity(), rowCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(rowCacheKeysToSave)));
        logger.info(String.format("%-25s%20s", "Table", "Memtable ops,data"));
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            logger.info(String.format("%-25s%20s", cfs.keyspace.getName() + "." + cfs.name, cfs.metric.memtableColumnsCount.getValue() + "," + cfs.metric.memtableLiveDataSize.getValue()));
        }
    }
}

