/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ReversedType;
import com.github.cassandra.jdbc.internal.cassandra.dht.IPartitioner;
import com.github.cassandra.jdbc.internal.cassandra.dht.Range;
import com.github.cassandra.jdbc.internal.cassandra.dht.RingPosition;
import com.github.cassandra.jdbc.internal.cassandra.dht.Token;
import com.github.cassandra.jdbc.internal.cassandra.io.sstable.SSTableLoader;
import com.github.cassandra.jdbc.internal.cassandra.schema.CQLTypeParser;
import com.github.cassandra.jdbc.internal.cassandra.schema.Types;
import com.github.cassandra.jdbc.internal.cassandra.utils.FBUtilities;
import com.github.cassandra.jdbc.internal.datastax.driver.core.AuthProvider;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Cluster;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Host;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Metadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.PlainTextAuthProvider;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Row;
import com.github.cassandra.jdbc.internal.datastax.driver.core.SSLOptions;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Session;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TokenRange;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class NativeSSTableLoaderClient
extends SSTableLoader.Client {
    protected final Map<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
    private final Collection<InetAddress> hosts;
    private final int port;
    private final AuthProvider authProvider;
    private final SSLOptions sslOptions;

    public NativeSSTableLoaderClient(Collection<InetAddress> hosts, int port, String username, String password, SSLOptions sslOptions) {
        this(hosts, port, new PlainTextAuthProvider(username, password), sslOptions);
    }

    public NativeSSTableLoaderClient(Collection<InetAddress> hosts, int port, AuthProvider authProvider, SSLOptions sslOptions) {
        this.hosts = hosts;
        this.port = port;
        this.authProvider = authProvider;
        this.sslOptions = sslOptions;
    }

    public void init(String keyspace) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(this.hosts).withPort(this.port);
        if (this.sslOptions != null) {
            builder.withSSL(this.sslOptions);
        }
        if (this.authProvider != null) {
            builder = builder.withAuthProvider(this.authProvider);
        }
        try (Cluster cluster = builder.build();
             Session session = cluster.connect();){
            Metadata metadata = cluster.getMetadata();
            Set<TokenRange> tokenRanges = metadata.getTokenRanges();
            IPartitioner partitioner = FBUtilities.newPartitioner(metadata.getPartitioner());
            Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
            for (TokenRange tokenRange : tokenRanges) {
                Set<Host> endpoints = metadata.getReplicas(Metadata.quote(keyspace), tokenRange);
                Range range = new Range((RingPosition)tokenFactory.fromString(tokenRange.getStart().getValue().toString()), (RingPosition)tokenFactory.fromString(tokenRange.getEnd().getValue().toString()));
                for (Host endpoint : endpoints) {
                    this.addRangeForEndpoint(range, endpoint.getAddress());
                }
            }
            Types types = NativeSSTableLoaderClient.fetchTypes(keyspace, session);
            this.tables.putAll(NativeSSTableLoaderClient.fetchTables(keyspace, session, partitioner, types));
            this.tables.putAll(NativeSSTableLoaderClient.fetchViews(keyspace, session, partitioner, types));
        }
    }

    public CFMetaData getTableMetadata(String tableName) {
        return this.tables.get(tableName);
    }

    public void setTableMetadata(CFMetaData cfm) {
        this.tables.put(cfm.cfName, cfm);
    }

    private static Types fetchTypes(String keyspace, Session session) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "types");
        Types.RawBuilder types = Types.rawBuilder((String)keyspace);
        for (Row row : session.execute(query, keyspace)) {
            String name = row.getString("type_name");
            List<String> fieldNames = row.getList("field_names", String.class);
            List<String> fieldTypes = row.getList("field_types", String.class);
            types.add(name, fieldNames, fieldTypes);
        }
        return types.build();
    }

    private static Map<String, CFMetaData> fetchTables(String keyspace, Session session, IPartitioner partitioner, Types types) {
        HashMap<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "tables");
        for (Row row : session.execute(query, keyspace)) {
            String name = row.getString("table_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, false, row, name, types));
        }
        return tables;
    }

    private static Map<String, CFMetaData> fetchViews(String keyspace, Session session, IPartitioner partitioner, Types types) {
        HashMap<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "views");
        for (Row row : session.execute(query, keyspace)) {
            String name = row.getString("view_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, true, row, name, types));
        }
        return tables;
    }

    private static CFMetaData createTableMetadata(String keyspace, Session session, IPartitioner partitioner, boolean isView, Row row, String name, Types types) {
        UUID id = row.getUUID("id");
        Set flags = isView ? Collections.emptySet() : CFMetaData.flagsFromStrings(row.getSet("flags", String.class));
        boolean isSuper = flags.contains((Object)CFMetaData.Flag.SUPER);
        boolean isCounter = flags.contains((Object)CFMetaData.Flag.COUNTER);
        boolean isDense = flags.contains((Object)CFMetaData.Flag.DENSE);
        boolean isCompound = isView || flags.contains((Object)CFMetaData.Flag.COMPOUND);
        String columnsQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", "columns");
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>();
        for (Row colRow : session.execute(columnsQuery, keyspace, name)) {
            defs.add(NativeSSTableLoaderClient.createDefinitionFromRow(colRow, keyspace, name, types));
        }
        return CFMetaData.create(keyspace, name, id, isDense, isCompound, isSuper, isCounter, isView, defs, partitioner);
    }

    private static ColumnDefinition createDefinitionFromRow(Row row, String keyspace, String table, Types types) {
        ColumnIdentifier name = ColumnIdentifier.getInterned(row.getBytes("column_name_bytes"), row.getString("column_name"));
        ColumnDefinition.ClusteringOrder order = ColumnDefinition.ClusteringOrder.valueOf(row.getString("clustering_order").toUpperCase());
        ReversedType type = CQLTypeParser.parse((String)keyspace, (String)row.getString("type"), (Types)types);
        if (order == ColumnDefinition.ClusteringOrder.DESC) {
            type = ReversedType.getInstance(type);
        }
        int position = row.getInt("position");
        ColumnDefinition.Kind kind = ColumnDefinition.Kind.valueOf(row.getString("kind").toUpperCase());
        return new ColumnDefinition(keyspace, table, name, type, position, kind);
    }
}

