/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.github.cassandra.jdbc.internal.cassandra.io.util.DataOutputPlus;
import com.github.cassandra.jdbc.internal.cassandra.utils.AlwaysPresentFilter;
import com.github.cassandra.jdbc.internal.cassandra.utils.BloomCalculations;
import com.github.cassandra.jdbc.internal.cassandra.utils.BloomFilter;
import com.github.cassandra.jdbc.internal.cassandra.utils.BloomFilterSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.IFilter;
import com.github.cassandra.jdbc.internal.cassandra.utils.obs.IBitSet;
import com.github.cassandra.jdbc.internal.cassandra.utils.obs.OffHeapBitSet;
import com.github.cassandra.jdbc.internal.cassandra.utils.obs.OpenBitSet;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import java.io.DataInput;
import java.io.IOException;

public class FilterFactory {
    public static final IFilter AlwaysPresent = new AlwaysPresentFilter();
    private static final Logger logger = LoggerFactory.getLogger(FilterFactory.class);
    private static final long BITSET_EXCESS = 20L;

    public static void serialize(IFilter bf, DataOutputPlus output) throws IOException {
        BloomFilterSerializer.serialize((BloomFilter)bf, output);
    }

    public static IFilter deserialize(DataInput input, boolean offheap, boolean oldBfHashOrder) throws IOException {
        return BloomFilterSerializer.deserialize(input, offheap, oldBfHashOrder);
    }

    public static IFilter getFilter(long numElements, int targetBucketsPerElem, boolean offheap, boolean oldBfHashOrder) {
        int maxBucketsPerElement = Math.max(1, BloomCalculations.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            logger.warn(String.format("Cannot provide an optimal BloomFilter for %d elements (%d/%d buckets per element).", numElements, bucketsPerElement, targetBucketsPerElem));
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement, offheap, oldBfHashOrder);
    }

    public static IFilter getFilter(long numElements, double maxFalsePosProbability, boolean offheap, boolean oldBfHashOrder) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        if (maxFalsePosProbability == 1.0) {
            return new AlwaysPresentFilter();
        }
        int bucketsPerElement = BloomCalculations.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement, offheap, oldBfHashOrder);
    }

    private static IFilter createFilter(int hash, long numElements, int bucketsPer, boolean offheap, boolean oldBfHashOrder) {
        long numBits = numElements * (long)bucketsPer + 20L;
        OffHeapBitSet bitset = offheap ? new OffHeapBitSet(numBits) : new OpenBitSet(numBits);
        return new BloomFilter(hash, (IBitSet)bitset, oldBfHashOrder);
    }
}

