/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.github.cassandra.jdbc.internal.cassandra.db.TypeSizes;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataOutputPlus;
import com.github.cassandra.jdbc.internal.cassandra.utils.BloomFilter;
import com.github.cassandra.jdbc.internal.cassandra.utils.obs.IBitSet;
import com.github.cassandra.jdbc.internal.cassandra.utils.obs.OffHeapBitSet;
import com.github.cassandra.jdbc.internal.cassandra.utils.obs.OpenBitSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class BloomFilterSerializer {
    private BloomFilterSerializer() {
    }

    public static void serialize(BloomFilter bf, DataOutputPlus out) throws IOException {
        out.writeInt(bf.hashCount);
        bf.bitset.serialize((DataOutput)out);
    }

    public static BloomFilter deserialize(DataInput in, boolean oldBfHashOrder) throws IOException {
        return BloomFilterSerializer.deserialize(in, false, oldBfHashOrder);
    }

    public static BloomFilter deserialize(DataInput in, boolean offheap, boolean oldBfHashOrder) throws IOException {
        int hashes = in.readInt();
        OffHeapBitSet bs = offheap ? OffHeapBitSet.deserialize((DataInput)in) : OpenBitSet.deserialize((DataInput)in);
        return new BloomFilter(hashes, (IBitSet)bs, oldBfHashOrder);
    }

    public static long serializedSize(BloomFilter bf) {
        int size = TypeSizes.sizeof((int)bf.hashCount);
        size = (int)((long)size + bf.bitset.serializedSize());
        return size;
    }
}

