/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.utils;

import com.github.cassandra.jdbc.internal.google.common.collect.PeekingIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<V>
implements Iterator<V>,
PeekingIterator<V> {
    private State state = State.MUST_FETCH;
    private V next;

    protected V endOfData() {
        this.state = State.DONE;
        return null;
    }

    protected abstract V computeNext();

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case MUST_FETCH: {
                this.state = State.FAILED;
                this.next = this.computeNext();
            }
            default: {
                if (this.state == State.DONE) {
                    return false;
                }
                this.state = State.HAS_NEXT;
                return true;
            }
            case FAILED: 
        }
        throw new IllegalStateException();
    }

    @Override
    public V next() {
        if (this.state != State.HAS_NEXT && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.MUST_FETCH;
        V result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public V peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum State {
        MUST_FETCH,
        HAS_NEXT,
        DONE,
        FAILED;

    }
}

