/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.transport;

import com.github.cassandra.jdbc.internal.cassandra.auth.IAuthenticator;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.transport.Connection;
import com.github.cassandra.jdbc.internal.cassandra.transport.Message;
import com.github.cassandra.jdbc.internal.cassandra.transport.ProtocolException;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServerConnection
extends Connection {
    private volatile IAuthenticator.SaslNegotiator saslNegotiator;
    private final ClientState clientState;
    private volatile State state;
    private final ConcurrentMap<Integer, QueryState> queryStates = new ConcurrentHashMap<Integer, QueryState>();

    public ServerConnection(Channel channel, int version, Connection.Tracker tracker) {
        super(channel, version, tracker);
        this.clientState = ClientState.forExternalCalls((SocketAddress)channel.remoteAddress());
        this.state = State.UNINITIALIZED;
    }

    private QueryState getQueryState(int streamId) {
        QueryState qState = (QueryState)this.queryStates.get(streamId);
        if (qState == null) {
            QueryState newState = new QueryState(this.clientState);
            qState = this.queryStates.putIfAbsent(streamId, newState);
            if (qState == null) {
                qState = newState;
            }
        }
        return qState;
    }

    public QueryState validateNewMessage(Message.Type type, int version, int streamId) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (type == Message.Type.STARTUP || type == Message.Type.OPTIONS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting STARTUP or OPTIONS", new Object[]{type}));
            }
            case AUTHENTICATION: {
                if (type == Message.Type.AUTH_RESPONSE || type == Message.Type.CREDENTIALS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting %s", new Object[]{type, version == 1 ? "CREDENTIALS" : "SASL_RESPONSE"}));
            }
            case READY: {
                if (type != Message.Type.STARTUP) break;
                throw new ProtocolException("Unexpected message STARTUP, the connection is already initialized");
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.getQueryState(streamId);
    }

    public void applyStateTransition(Message.Type requestType, Message.Type responseType) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (requestType != Message.Type.STARTUP) break;
                if (responseType == Message.Type.AUTHENTICATE) {
                    this.state = State.AUTHENTICATION;
                    break;
                }
                if (responseType != Message.Type.READY) break;
                this.state = State.READY;
                break;
            }
            case AUTHENTICATION: {
                assert (requestType == Message.Type.AUTH_RESPONSE || requestType == Message.Type.CREDENTIALS);
                if (responseType != Message.Type.READY && responseType != Message.Type.AUTH_SUCCESS) break;
                this.state = State.READY;
                this.saslNegotiator = null;
                break;
            }
            case READY: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public IAuthenticator.SaslNegotiator getSaslNegotiator(QueryState queryState) {
        if (this.saslNegotiator == null) {
            this.saslNegotiator = DatabaseDescriptor.getAuthenticator().newSaslNegotiator(queryState.getClientAddress());
        }
        return this.saslNegotiator;
    }

    private static enum State {
        UNINITIALIZED,
        AUTHENTICATION,
        READY;

    }
}

