/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.transport;

import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AsciiType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.BooleanType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ByteType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.BytesType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CounterColumnType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.DateType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.DecimalType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.DoubleType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.FloatType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.InetAddressType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.Int32Type;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.IntegerType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ListType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.LongType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.MapType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ReversedType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.SetType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ShortType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.SimpleDateType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.TimeType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.TimeUUIDType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.TimestampType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.TupleType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.TypeParser;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UTF8Type;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UUIDType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UserType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.transport.CBUtil;
import com.github.cassandra.jdbc.internal.cassandra.transport.OptionCodec;
import com.github.cassandra.jdbc.internal.cassandra.transport.ProtocolException;
import com.github.cassandra.jdbc.internal.cassandra.utils.Pair;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.ByteBuf;
import com.github.cassandra.jdbc.internal.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataType
extends Enum<DataType>
implements OptionCodec.Codecable<DataType> {
    public static final /* enum */ DataType CUSTOM = new DataType(0, null, 1);
    public static final /* enum */ DataType ASCII = new DataType(1, AsciiType.instance, 1);
    public static final /* enum */ DataType BIGINT = new DataType(2, LongType.instance, 1);
    public static final /* enum */ DataType BLOB = new DataType(3, BytesType.instance, 1);
    public static final /* enum */ DataType BOOLEAN = new DataType(4, BooleanType.instance, 1);
    public static final /* enum */ DataType COUNTER = new DataType(5, CounterColumnType.instance, 1);
    public static final /* enum */ DataType DECIMAL = new DataType(6, DecimalType.instance, 1);
    public static final /* enum */ DataType DOUBLE = new DataType(7, DoubleType.instance, 1);
    public static final /* enum */ DataType FLOAT = new DataType(8, FloatType.instance, 1);
    public static final /* enum */ DataType INT = new DataType(9, Int32Type.instance, 1);
    public static final /* enum */ DataType TEXT = new DataType(10, UTF8Type.instance, 1);
    public static final /* enum */ DataType TIMESTAMP = new DataType(11, TimestampType.instance, 1);
    public static final /* enum */ DataType UUID = new DataType(12, UUIDType.instance, 1);
    public static final /* enum */ DataType VARCHAR = new DataType(13, UTF8Type.instance, 1);
    public static final /* enum */ DataType VARINT = new DataType(14, IntegerType.instance, 1);
    public static final /* enum */ DataType TIMEUUID = new DataType(15, TimeUUIDType.instance, 1);
    public static final /* enum */ DataType INET = new DataType(16, InetAddressType.instance, 1);
    public static final /* enum */ DataType DATE = new DataType(17, SimpleDateType.instance, 4);
    public static final /* enum */ DataType TIME = new DataType(18, TimeType.instance, 4);
    public static final /* enum */ DataType SMALLINT = new DataType(19, ShortType.instance, 4);
    public static final /* enum */ DataType BYTE = new DataType(20, ByteType.instance, 4);
    public static final /* enum */ DataType LIST = new DataType(32, null, 1);
    public static final /* enum */ DataType MAP = new DataType(33, null, 1);
    public static final /* enum */ DataType SET = new DataType(34, null, 1);
    public static final /* enum */ DataType UDT = new DataType(48, null, 3);
    public static final /* enum */ DataType TUPLE = new DataType(49, null, 3);
    public static final OptionCodec<DataType> codec;
    private final int id;
    private final int protocolVersion;
    private final AbstractType type;
    private static final Map<AbstractType, DataType> dataTypeMap;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(int id, AbstractType type, int protocolVersion) {
        this.id = id;
        this.type = type;
        this.protocolVersion = protocolVersion;
    }

    @Override
    public int getId(int version) {
        if (version < this.protocolVersion) {
            return CUSTOM.getId(version);
        }
        return this.id;
    }

    @Override
    public Object readValue(ByteBuf cb, int version) {
        switch (this) {
            case CUSTOM: {
                return CBUtil.readString(cb);
            }
            case LIST: {
                return DataType.toType(codec.decodeOne(cb, version));
            }
            case SET: {
                return DataType.toType(codec.decodeOne(cb, version));
            }
            case MAP: {
                ArrayList<AbstractType> l = new ArrayList<AbstractType>(2);
                l.add(DataType.toType(codec.decodeOne(cb, version)));
                l.add(DataType.toType(codec.decodeOne(cb, version)));
                return l;
            }
            case UDT: {
                String ks = CBUtil.readString(cb);
                ByteBuffer name = UTF8Type.instance.decompose(CBUtil.readString(cb));
                int n = cb.readUnsignedShort();
                ArrayList<ByteBuffer> fieldNames = new ArrayList<ByteBuffer>(n);
                ArrayList fieldTypes = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    fieldNames.add(UTF8Type.instance.decompose(CBUtil.readString(cb)));
                    fieldTypes.add(DataType.toType(codec.decodeOne(cb, version)));
                }
                return new UserType(ks, name, fieldNames, fieldTypes);
            }
            case TUPLE: {
                int n = cb.readUnsignedShort();
                ArrayList types = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    types.add(DataType.toType(codec.decodeOne(cb, version)));
                }
                return new TupleType(types);
            }
        }
        return null;
    }

    @Override
    public void writeValue(Object value, ByteBuf cb, int version) {
        if (version < this.protocolVersion) {
            CBUtil.writeString(value.toString(), cb);
            return;
        }
        switch (this) {
            case CUSTOM: {
                assert (value instanceof String);
                CBUtil.writeString((String)value, cb);
                break;
            }
            case LIST: {
                codec.writeOne(DataType.fromType((AbstractType)value, version), cb, version);
                break;
            }
            case SET: {
                codec.writeOne(DataType.fromType((AbstractType)value, version), cb, version);
                break;
            }
            case MAP: {
                List l = (List)value;
                codec.writeOne(DataType.fromType((AbstractType)l.get(0), version), cb, version);
                codec.writeOne(DataType.fromType((AbstractType)l.get(1), version), cb, version);
                break;
            }
            case UDT: {
                UserType udt = (UserType)value;
                CBUtil.writeString(udt.keyspace, cb);
                CBUtil.writeString((String)UTF8Type.instance.compose(udt.name), cb);
                cb.writeShort(udt.size());
                for (int i = 0; i < udt.size(); ++i) {
                    CBUtil.writeString((String)UTF8Type.instance.compose(udt.fieldName(i)), cb);
                    codec.writeOne(DataType.fromType(udt.fieldType(i), version), cb, version);
                }
                break;
            }
            case TUPLE: {
                TupleType tt = (TupleType)value;
                cb.writeShort(tt.size());
                for (int i = 0; i < tt.size(); ++i) {
                    codec.writeOne(DataType.fromType(tt.type(i), version), cb, version);
                }
                break;
            }
        }
    }

    @Override
    public int serializedValueSize(Object value, int version) {
        if (version < this.protocolVersion) {
            return CBUtil.sizeOfString(value.toString());
        }
        switch (this) {
            case CUSTOM: {
                return CBUtil.sizeOfString((String)value);
            }
            case LIST: 
            case SET: {
                return codec.oneSerializedSize(DataType.fromType((AbstractType)value, version), version);
            }
            case MAP: {
                List l = (List)value;
                int s = 0;
                s += codec.oneSerializedSize(DataType.fromType((AbstractType)l.get(0), version), version);
                return s += codec.oneSerializedSize(DataType.fromType((AbstractType)l.get(1), version), version);
            }
            case UDT: {
                UserType udt = (UserType)value;
                int size = 0;
                size += CBUtil.sizeOfString(udt.keyspace);
                size += CBUtil.sizeOfString((String)UTF8Type.instance.compose(udt.name));
                size += 2;
                for (int i = 0; i < udt.size(); ++i) {
                    size += CBUtil.sizeOfString((String)UTF8Type.instance.compose(udt.fieldName(i)));
                    size += codec.oneSerializedSize(DataType.fromType(udt.fieldType(i), version), version);
                }
                return size;
            }
            case TUPLE: {
                TupleType tt = (TupleType)value;
                int size = 2;
                for (int i = 0; i < tt.size(); ++i) {
                    size += codec.oneSerializedSize(DataType.fromType(tt.type(i), version), version);
                }
                return size;
            }
        }
        return 0;
    }

    public static Pair<DataType, Object> fromType(AbstractType type, int version) {
        DataType dt;
        if (type instanceof ReversedType) {
            type = ((ReversedType)((Object)type)).baseType;
        }
        if (type instanceof DateType) {
            type = TimestampType.instance;
        }
        if ((dt = dataTypeMap.get(type)) == null) {
            if (type.isCollection()) {
                if (type instanceof ListType) {
                    return Pair.create(LIST, ((ListType)((Object)type)).getElementsType());
                }
                if (type instanceof MapType) {
                    MapType mt = (MapType)((Object)type);
                    return Pair.create(MAP, Arrays.asList(mt.getKeysType(), mt.getValuesType()));
                }
                if (type instanceof SetType) {
                    return Pair.create(SET, ((SetType)((Object)type)).getElementsType());
                }
                throw new AssertionError();
            }
            if (type instanceof UserType && version >= DataType.UDT.protocolVersion) {
                return Pair.create(UDT, type);
            }
            if (type instanceof TupleType && version >= DataType.TUPLE.protocolVersion) {
                return Pair.create(TUPLE, type);
            }
            return Pair.create(CUSTOM, type.toString());
        }
        if (version < dt.protocolVersion) {
            return Pair.create(CUSTOM, type.toString());
        }
        return Pair.create(dt, null);
    }

    public static AbstractType toType(Pair<DataType, Object> entry) {
        try {
            switch ((DataType)entry.left) {
                case CUSTOM: {
                    return TypeParser.parse((String)entry.right);
                }
                case LIST: {
                    return ListType.getInstance((AbstractType)entry.right, true);
                }
                case SET: {
                    return SetType.getInstance((AbstractType)entry.right, true);
                }
                case MAP: {
                    List l = (List)entry.right;
                    return MapType.getInstance((AbstractType)l.get(0), (AbstractType)l.get(1), true);
                }
                case UDT: {
                    return (AbstractType)entry.right;
                }
                case TUPLE: {
                    return (AbstractType)entry.right;
                }
            }
            return ((DataType)entry.left).type;
        }
        catch (RequestValidationException e) {
            throw new ProtocolException(e.getMessage());
        }
    }

    @VisibleForTesting
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    static {
        $VALUES = new DataType[]{CUSTOM, ASCII, BIGINT, BLOB, BOOLEAN, COUNTER, DECIMAL, DOUBLE, FLOAT, INT, TEXT, TIMESTAMP, UUID, VARCHAR, VARINT, TIMEUUID, INET, DATE, TIME, SMALLINT, BYTE, LIST, MAP, SET, UDT, TUPLE};
        codec = new OptionCodec<DataType>(DataType.class);
        dataTypeMap = new HashMap<AbstractType, DataType>();
        for (DataType type : DataType.values()) {
            if (type.type == null) continue;
            dataTypeMap.put(type.type, type);
        }
    }
}

