/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.transport;

import com.github.cassandra.jdbc.internal.cassandra.config.Config;
import com.github.cassandra.jdbc.internal.cassandra.config.EncryptionOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.db.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.Int32Type;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UTF8Type;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import com.github.cassandra.jdbc.internal.cassandra.transport.FrameCompressor;
import com.github.cassandra.jdbc.internal.cassandra.transport.Message;
import com.github.cassandra.jdbc.internal.cassandra.transport.SimpleClient;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.AuthResponse;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.CredentialsMessage;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ExecuteMessage;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.OptionsMessage;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.PrepareMessage;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.QueryMessage;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.RegisterMessage;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.StartupMessage;
import com.github.cassandra.jdbc.internal.cassandra.utils.Hex;
import com.github.cassandra.jdbc.internal.cassandra.utils.JVMStabilityInspector;
import com.github.cassandra.jdbc.internal.cassandra.utils.MD5Digest;
import com.github.cassandra.jdbc.internal.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Client
extends SimpleClient {
    private final SimpleClient.SimpleEventHandler eventHandler = new SimpleClient.SimpleEventHandler();

    public Client(String host, int port, int version, EncryptionOptions.ClientEncryptionOptions encryptionOptions) {
        super(host, port, version, encryptionOptions);
        this.setEventHandler(this.eventHandler);
    }

    public void run() throws IOException {
        System.out.print("Connecting...");
        this.establishConnection();
        System.out.println();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            Event event;
            if ((event = this.eventHandler.queue.poll()) != null) {
                System.out.println("<< " + event);
                continue;
            }
            System.out.print(">> ");
            System.out.flush();
            String line = in.readLine();
            if (line == null) break;
            Message.Request req = this.parseLine(line.trim());
            if (req == null) {
                System.out.println("! Error parsing line.");
                continue;
            }
            try {
                Message.Response resp = this.execute(req);
                System.out.println("-> " + resp);
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                System.err.println("ERROR: " + e.getMessage());
            }
        }
        this.close();
    }

    private Message.Request parseLine(String line) {
        Splitter splitter = Splitter.on(' ').trimResults().omitEmptyStrings();
        Iterator<String> iter = splitter.split(line).iterator();
        if (!iter.hasNext()) {
            return null;
        }
        String msgType = iter.next().toUpperCase();
        if (msgType.equals("STARTUP")) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("CQL_VERSION", "3.0.0");
            while (iter.hasNext()) {
                String next = iter.next();
                if (!next.toLowerCase().equals("snappy")) continue;
                options.put("COMPRESSION", "snappy");
                this.connection.setCompressor(FrameCompressor.SnappyCompressor.instance);
            }
            return new StartupMessage(options);
        }
        if (msgType.equals("QUERY")) {
            String query = line = line.substring(6);
            int pageSize = -1;
            if (line.matches(".+ !\\d+$")) {
                int idx = line.lastIndexOf(33);
                query = line.substring(0, idx - 1);
                try {
                    pageSize = Integer.parseInt(line.substring(idx + 1, line.length()));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return new QueryMessage(query, QueryOptions.create(ConsistencyLevel.ONE, Collections.emptyList(), false, pageSize, null, null));
        }
        if (msgType.equals("PREPARE")) {
            String query = line.substring(8);
            return new PrepareMessage(query);
        }
        if (msgType.equals("EXECUTE")) {
            try {
                byte[] id = Hex.hexToBytes(iter.next());
                ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
                while (iter.hasNext()) {
                    ByteBuffer bb;
                    String next = iter.next();
                    try {
                        int v = Integer.parseInt(next);
                        bb = Int32Type.instance.decompose(v);
                    }
                    catch (NumberFormatException e) {
                        bb = UTF8Type.instance.decompose(next);
                    }
                    values.add(bb);
                }
                return new ExecuteMessage(MD5Digest.wrap(id), QueryOptions.forInternalCalls(ConsistencyLevel.ONE, values));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (msgType.equals("OPTIONS")) {
            return new OptionsMessage();
        }
        if (msgType.equals("CREDENTIALS")) {
            System.err.println("[WARN] CREDENTIALS command is deprecated, use AUTHENTICATE instead");
            CredentialsMessage msg = new CredentialsMessage();
            msg.credentials.putAll(this.readCredentials(iter));
            return msg;
        }
        if (msgType.equals("AUTHENTICATE")) {
            Map<String, String> credentials = this.readCredentials(iter);
            if (!credentials.containsKey("username") || !credentials.containsKey("password")) {
                System.err.println("[ERROR] Authentication requires both 'username' and 'password'");
                return null;
            }
            return new AuthResponse(this.encodeCredentialsForSasl(credentials));
        }
        if (msgType.equals("REGISTER")) {
            String type = line.substring(9).toUpperCase();
            try {
                return new RegisterMessage(Collections.singletonList(Enum.valueOf(Event.Type.class, type)));
            }
            catch (IllegalArgumentException e) {
                System.err.println("[ERROR] Unknown event type: " + type);
                return null;
            }
        }
        return null;
    }

    private Map<String, String> readCredentials(Iterator<String> iter) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        while (iter.hasNext()) {
            String next = iter.next();
            String[] kv = next.split("=");
            if (kv.length != 2) {
                System.err.println("[ERROR] Default authentication requires username & password");
                return null;
            }
            credentials.put(kv[0], kv[1]);
        }
        return credentials;
    }

    private byte[] encodeCredentialsForSasl(Map<String, String> credentials) {
        byte[] username = credentials.get("username").getBytes(StandardCharsets.UTF_8);
        byte[] password = credentials.get("password").getBytes(StandardCharsets.UTF_8);
        byte[] initialResponse = new byte[username.length + password.length + 2];
        initialResponse[0] = 0;
        System.arraycopy(username, 0, initialResponse, 1, username.length);
        initialResponse[username.length + 1] = 0;
        System.arraycopy(password, 0, initialResponse, username.length + 2, password.length);
        return initialResponse;
    }

    public static void main(String[] args) throws Exception {
        Config.setClientMode(true);
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: " + Client.class.getSimpleName() + " <host> <port> [<version>]");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int version = args.length == 3 ? Integer.parseInt(args[2]) : 4;
        EncryptionOptions.ClientEncryptionOptions encryptionOptions = new EncryptionOptions.ClientEncryptionOptions();
        System.out.println("CQL binary protocol console " + host + "@" + port + " using native protocol version " + version);
        new Client(host, port, version, encryptionOptions).run();
        System.exit(0);
    }
}

