/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.serializers;

import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.cassandra.utils.UUIDGen;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UUIDSerializer
implements TypeSerializer<UUID> {
    public static final UUIDSerializer instance = new UUIDSerializer();

    @Override
    public UUID deserialize(ByteBuffer bytes) {
        return bytes.remaining() == 0 ? null : UUIDGen.getUUID(bytes);
    }

    @Override
    public ByteBuffer serialize(UUID value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : UUIDGen.toByteBuffer(value);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 16 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("UUID should be 16 or 0 bytes (%d)", bytes.remaining()));
        }
    }

    @Override
    public String toString(UUID value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Class<UUID> getType() {
        return UUID.class;
    }
}

