/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.serializers;

import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.UUIDSerializer;
import java.nio.ByteBuffer;

public class TimeUUIDSerializer
extends UUIDSerializer {
    public static final TimeUUIDSerializer instance = new TimeUUIDSerializer();

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        super.validate(bytes);
        ByteBuffer slice = bytes.slice();
        if (bytes.remaining() > 0) {
            slice.position(6);
            if ((slice.get() & 0xF0) != 16) {
                throw new MarshalException("Invalid version for TimeUUID type.");
            }
        }
    }
}

