/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.serializers;

import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class BytesSerializer
implements TypeSerializer<ByteBuffer> {
    public static final BytesSerializer instance = new BytesSerializer();

    @Override
    public ByteBuffer serialize(ByteBuffer bytes) {
        return bytes.duplicate();
    }

    @Override
    public ByteBuffer deserialize(ByteBuffer value) {
        return value;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }

    @Override
    public String toString(ByteBuffer value) {
        return ByteBufferUtil.bytesToHex(value);
    }

    @Override
    public Class<ByteBuffer> getType() {
        return ByteBuffer.class;
    }

    @Override
    public String toCQLLiteral(ByteBuffer buffer) {
        return buffer == null ? "null" : "0x" + this.toString(this.deserialize(buffer));
    }
}

