/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.serializers;

import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class ByteSerializer
implements TypeSerializer<Byte> {
    public static final ByteSerializer instance = new ByteSerializer();

    @Override
    public Byte deserialize(ByteBuffer bytes) {
        return bytes == null || bytes.remaining() == 0 ? null : Byte.valueOf(bytes.get(bytes.position()));
    }

    @Override
    public ByteBuffer serialize(Byte value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.allocate(1).put(0, value);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 1) {
            throw new MarshalException(String.format("Expected 1 byte for a tinyint (%d)", bytes.remaining()));
        }
    }

    @Override
    public String toString(Byte value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Byte> getType() {
        return Byte.class;
    }
}

