/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.serializers;

import com.github.cassandra.jdbc.internal.cassandra.serializers.AbstractTextSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class AsciiSerializer
extends AbstractTextSerializer {
    public static final AsciiSerializer instance = new AsciiSerializer();

    private AsciiSerializer() {
        super(StandardCharsets.US_ASCII);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        for (int i = bytes.position(); i < bytes.limit(); ++i) {
            byte b = bytes.get(i);
            if (b >= 0) continue;
            throw new MarshalException("Invalid byte for ascii: " + Byte.toString(b));
        }
    }
}

