/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.io.util;

import com.github.cassandra.jdbc.internal.cassandra.io.util.DataOutputStreamPlus;
import com.github.cassandra.jdbc.internal.cassandra.io.util.Memory;
import com.github.cassandra.jdbc.internal.cassandra.utils.memory.MemoryUtil;
import com.github.cassandra.jdbc.internal.google.common.base.Function;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class UnbufferedDataOutputStreamPlus
extends DataOutputStreamPlus {
    private static final byte[] zeroBytes = new byte[2];
    private final ByteBuffer hollowBufferD = MemoryUtil.getHollowDirectByteBuffer();

    protected UnbufferedDataOutputStreamPlus() {
    }

    protected UnbufferedDataOutputStreamPlus(WritableByteChannel channel) {
        super(channel);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.write(val & 0xFF);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        byte[] bytes = new byte[str.length()];
        for (int index = 0; index < str.length(); ++index) {
            bytes[index] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(bytes);
    }

    @Override
    public final void writeChar(int val) throws IOException {
        this.write(val >>> 8 & 0xFF);
        this.write(val >>> 0 & 0xFF);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        byte[] newBytes = new byte[str.length() * 2];
        for (int index = 0; index < str.length(); ++index) {
            int newIndex = index == 0 ? index : index * 2;
            newBytes[newIndex] = (byte)(str.charAt(index) >> 8 & 0xFF);
            newBytes[newIndex + 1] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(newBytes);
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.write(val >>> 24 & 0xFF);
        this.write(val >>> 16 & 0xFF);
        this.write(val >>> 8 & 0xFF);
        this.write(val >>> 0 & 0xFF);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.write((int)(val >>> 56) & 0xFF);
        this.write((int)(val >>> 48) & 0xFF);
        this.write((int)(val >>> 40) & 0xFF);
        this.write((int)(val >>> 32) & 0xFF);
        this.write((int)(val >>> 24) & 0xFF);
        this.write((int)(val >>> 16) & 0xFF);
        this.write((int)(val >>> 8) & 0xFF);
        this.write((int)(val >>> 0) & 0xFF);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.writeChar(val);
    }

    public static void writeUTF(String str, DataOutput out) throws IOException {
        int length = str.length();
        if (length == 0) {
            out.write(zeroBytes);
            return;
        }
        int utfCount = 0;
        int maxSize = 2;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0000' & ch <= '\u007f') {
                ++utfCount;
                continue;
            }
            if (ch <= '\u07ff') {
                utfCount += 2;
                continue;
            }
            maxSize = 3;
            utfCount += 3;
        }
        if (utfCount > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] utfBytes = UnbufferedDataOutputStreamPlus.retrieveTemporaryBuffer(utfCount + 2);
        int bufferLength = utfBytes.length;
        if (utfCount == length) {
            utfBytes[0] = (byte)(utfCount >> 8);
            utfBytes[1] = (byte)utfCount;
            int firstIndex = 2;
            for (int offset = 0; offset < length; offset += bufferLength) {
                int runLength = Math.min(bufferLength - firstIndex, length - offset) + firstIndex;
                offset -= firstIndex;
                for (int i = firstIndex; i < runLength; ++i) {
                    utfBytes[i] = (byte)str.charAt(offset + i);
                }
                out.write(utfBytes, 0, runLength);
                firstIndex = 0;
            }
        } else {
            int utfIndex = 2;
            int offset = 0;
            utfBytes[0] = (byte)(utfCount >> 8);
            utfBytes[1] = (byte)utfCount;
            while (length > 0) {
                int charRunLength = (utfBytes.length - utfIndex) / maxSize;
                if (charRunLength < 128 && charRunLength < length) {
                    out.write(utfBytes, 0, utfIndex);
                    utfIndex = 0;
                }
                if (charRunLength > length) {
                    charRunLength = length;
                }
                for (int i = 0; i < charRunLength; ++i) {
                    char ch = str.charAt(offset + i);
                    if (ch > '\u0000' && ch <= '\u007f') {
                        utfBytes[utfIndex++] = (byte)ch;
                        continue;
                    }
                    if (ch <= '\u07ff') {
                        utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & ch >> 6);
                        utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & ch);
                        continue;
                    }
                    utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & ch >> 12);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & ch >> 6);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & ch);
                }
                offset += charRunLength;
                length -= charRunLength;
            }
            out.write(utfBytes, 0, utfIndex);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        UnbufferedDataOutputStreamPlus.writeUTF(str, this);
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        if (buf.hasArray()) {
            this.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        } else {
            assert (buf.isDirect());
            MemoryUtil.duplicateDirectByteBuffer((ByteBuffer)buf, (ByteBuffer)this.hollowBufferD);
            while (this.hollowBufferD.hasRemaining()) {
                this.channel.write(this.hollowBufferD);
            }
        }
    }

    @Override
    public void write(Memory memory, long offset, long length) throws IOException {
        for (ByteBuffer buffer : memory.asByteBuffers(offset, length)) {
            this.write(buffer);
        }
    }

    @Override
    public <R> R applyToChannel(Function<WritableByteChannel, R> f) throws IOException {
        return f.apply(this.channel);
    }
}

