/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.io.util;

import com.github.cassandra.jdbc.internal.cassandra.io.util.BytesReadTracker;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TrackedInputStream
extends FilterInputStream
implements BytesReadTracker {
    private long bytesRead;

    public TrackedInputStream(InputStream source) {
        super(source);
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public void reset(long count) {
        this.bytesRead = count;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        ++this.bytesRead;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.bytesRead += (long)read;
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        this.bytesRead += (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.bytesRead += skip;
        return skip;
    }
}

