/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.io.util;

import com.github.cassandra.jdbc.internal.cassandra.io.util.DataOutputBuffer;
import com.github.cassandra.jdbc.internal.cassandra.io.util.Memory;
import com.github.cassandra.jdbc.internal.cassandra.io.util.SafeMemory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SafeMemoryWriter
extends DataOutputBuffer {
    private SafeMemory memory;

    public SafeMemoryWriter(long initialCapacity) {
        this(new SafeMemory(initialCapacity));
    }

    private SafeMemoryWriter(SafeMemory memory) {
        super(SafeMemoryWriter.tailBuffer(memory).order(ByteOrder.BIG_ENDIAN));
        this.memory = memory;
    }

    public SafeMemory currentBuffer() {
        return this.memory;
    }

    @Override
    protected void reallocate(long count) {
        long newCapacity = this.calculateNewSize(count);
        if (newCapacity != this.capacity()) {
            long position = this.length();
            ByteOrder order = this.buffer.order();
            SafeMemory oldBuffer = this.memory;
            this.memory = this.memory.copy(newCapacity);
            this.buffer = SafeMemoryWriter.tailBuffer(this.memory);
            int newPosition = (int)(position - SafeMemoryWriter.tailOffset(this.memory));
            this.buffer.position(newPosition);
            this.buffer.order(order);
            oldBuffer.free();
        }
    }

    public void setCapacity(long newCapacity) {
        this.reallocate(newCapacity);
    }

    @Override
    public void close() {
        this.memory.close();
    }

    public Throwable close(Throwable accumulate) {
        return this.memory.close(accumulate);
    }

    public long length() {
        return SafeMemoryWriter.tailOffset(this.memory) + (long)this.buffer.position();
    }

    @Override
    public long capacity() {
        return this.memory.size();
    }

    @Override
    public SafeMemoryWriter order(ByteOrder order) {
        super.order(order);
        return this;
    }

    @Override
    public long validateReallocation(long newSize) {
        return newSize;
    }

    private static long tailOffset(Memory memory) {
        return Math.max(0L, memory.size - Integer.MAX_VALUE);
    }

    private static ByteBuffer tailBuffer(Memory memory) {
        return memory.asByteBuffer(SafeMemoryWriter.tailOffset(memory), (int)Math.min(memory.size, Integer.MAX_VALUE));
    }
}

