/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.io.util;

import com.github.cassandra.jdbc.internal.cassandra.io.FSReadError;
import com.github.cassandra.jdbc.internal.cassandra.io.compress.BufferType;
import com.github.cassandra.jdbc.internal.cassandra.io.util.ChannelProxy;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataPosition;
import com.github.cassandra.jdbc.internal.cassandra.io.util.FileDataInput;
import com.github.cassandra.jdbc.internal.cassandra.io.util.MmappedRegions;
import com.github.cassandra.jdbc.internal.cassandra.io.util.RebufferingInputStream;
import com.github.cassandra.jdbc.internal.cassandra.utils.memory.BufferPool;
import com.github.cassandra.jdbc.internal.google.common.primitives.Ints;
import com.github.cassandra.jdbc.internal.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RandomAccessReader
extends RebufferingInputStream
implements FileDataInput {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int MAX_BUFFER_SIZE = 65536;
    protected final ChannelProxy channel;
    protected final MmappedRegions regions;
    protected final RateLimiter limiter;
    private final long fileLength;
    protected final int bufferSize;
    protected final BufferType bufferType;
    protected long bufferOffset;
    protected long markedPointer;

    protected RandomAccessReader(Builder builder) {
        super(builder.createBuffer());
        this.channel = builder.channel;
        this.regions = builder.regions;
        this.limiter = builder.limiter;
        this.fileLength = builder.overrideLength <= 0L ? builder.channel.size() : builder.overrideLength;
        this.bufferSize = builder.bufferSize;
        this.bufferType = builder.bufferType;
        this.buffer = builder.buffer;
    }

    protected static ByteBuffer allocateBuffer(int size, BufferType bufferType) {
        return BufferPool.get((int)size, (BufferType)bufferType).order(ByteOrder.BIG_ENDIAN);
    }

    protected void releaseBuffer() {
        if (this.buffer != null) {
            if (this.regions == null) {
                BufferPool.put((ByteBuffer)this.buffer);
            }
            this.buffer = null;
        }
    }

    @Override
    public void reBuffer() {
        if (this.isEOF()) {
            return;
        }
        if (this.regions == null) {
            this.reBufferStandard();
        } else {
            this.reBufferMmap();
        }
        if (this.limiter != null) {
            this.limiter.acquire(this.buffer.remaining());
        }
        assert (this.buffer.order() == ByteOrder.BIG_ENDIAN) : "Buffer must have BIG ENDIAN byte ordering";
    }

    protected void reBufferStandard() {
        this.bufferOffset += (long)this.buffer.position();
        assert (this.bufferOffset < this.fileLength);
        this.buffer.clear();
        long position = this.bufferOffset;
        long limit = this.bufferOffset;
        long pageAligedPos = position & 0xFFFFFFFFFFFFF000L;
        long upperLimit = Math.min(this.fileLength, pageAligedPos + (long)this.buffer.capacity());
        this.buffer.limit((int)(upperLimit - position));
        while (this.buffer.hasRemaining() && limit < upperLimit) {
            int n = this.channel.read(this.buffer, position);
            if (n < 0) {
                throw new FSReadError((Throwable)new IOException("Unexpected end of file"), this.channel.filePath());
            }
            position += (long)n;
            limit = this.bufferOffset + (long)this.buffer.position();
        }
        this.buffer.flip();
    }

    protected void reBufferMmap() {
        long position = this.bufferOffset + (long)this.buffer.position();
        assert (position < this.fileLength);
        MmappedRegions.Region region = this.regions.floor(position);
        this.bufferOffset = region.bottom();
        this.buffer = region.buffer.duplicate();
        this.buffer.position(Ints.checkedCast(position - this.bufferOffset));
        if (this.limiter != null && this.bufferSize < this.buffer.remaining()) {
            this.buffer.limit(this.buffer.position() + this.bufferSize);
        }
    }

    @Override
    public long getFilePointer() {
        return this.current();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    @Override
    public String getPath() {
        return this.channel.filePath();
    }

    public ChannelProxy getChannel() {
        return this.channel;
    }

    @Override
    public void reset() throws IOException {
        this.seek(this.markedPointer);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public long bytesPastMark() {
        long bytes = this.current() - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public DataPosition mark() {
        this.markedPointer = this.current();
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(DataPosition mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(DataPosition mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.current() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public int available() throws IOException {
        return Ints.saturatedCast(this.bytesRemaining());
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.bufferOffset += (long)this.buffer.position();
        this.releaseBuffer();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(filePath='" + (Object)((Object)this.channel) + "')";
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Attempted to seek in a closed RAR");
        }
        if (newPosition >= this.length()) {
            if (newPosition > this.length()) {
                throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
            }
            this.buffer.limit(0);
            this.bufferOffset = newPosition;
            return;
        }
        if (newPosition >= this.bufferOffset && newPosition < this.bufferOffset + (long)this.buffer.limit()) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
            return;
        }
        this.bufferOffset = newPosition;
        this.buffer.clear();
        this.reBuffer();
        assert (this.current() == newPosition);
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        long unreadPosition = -1L;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.getPosition();
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    public long length() {
        return this.fileLength;
    }

    public long getPosition() {
        return this.current();
    }

    public static RandomAccessReader open(File file) {
        return new Builder(new ChannelProxy(file)).buildWithChannel();
    }

    public static RandomAccessReader open(ChannelProxy channel) {
        return new Builder(channel).build();
    }

    public static class RandomAccessReaderWithOwnChannel
    extends RandomAccessReader {
        protected RandomAccessReaderWithOwnChannel(Builder builder) {
            super(builder);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                this.channel.close();
            }
        }
    }

    public static class Builder {
        public final ChannelProxy channel;
        public long overrideLength;
        public int bufferSize;
        public BufferType bufferType;
        public ByteBuffer buffer;
        public MmappedRegions regions;
        public RateLimiter limiter;

        public Builder(ChannelProxy channel) {
            this.channel = channel;
            this.overrideLength = -1L;
            this.bufferSize = 4096;
            this.bufferType = BufferType.OFF_HEAP;
            this.regions = null;
            this.limiter = null;
        }

        private void setBufferSize() {
            if (this.limiter != null) {
                this.bufferSize = 65536;
                return;
            }
            if ((this.bufferSize & 0xFFFFF000) != this.bufferSize) {
                this.bufferSize = this.bufferSize + 4095 & 0xFFFFF000;
            }
            this.bufferSize = Math.min(65536, this.bufferSize);
        }

        protected ByteBuffer createBuffer() {
            this.setBufferSize();
            this.buffer = this.regions == null ? RandomAccessReader.allocateBuffer(this.bufferSize, this.bufferType) : this.regions.floor((long)0L).buffer.duplicate();
            this.buffer.limit(0);
            return this.buffer;
        }

        public Builder overrideLength(long overrideLength) {
            this.overrideLength = overrideLength;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            if (bufferSize <= 0) {
                throw new IllegalArgumentException("bufferSize must be positive");
            }
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder bufferType(BufferType bufferType) {
            this.bufferType = bufferType;
            return this;
        }

        public Builder regions(MmappedRegions regions) {
            this.regions = regions;
            return this;
        }

        public Builder limiter(RateLimiter limiter) {
            this.limiter = limiter;
            return this;
        }

        public RandomAccessReader build() {
            return new RandomAccessReader(this);
        }

        public RandomAccessReader buildWithChannel() {
            return new RandomAccessReaderWithOwnChannel(this);
        }
    }

    protected static class BufferedRandomAccessFileMark
    implements DataPosition {
        final long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

