/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.io.util;

import com.github.cassandra.jdbc.internal.cassandra.io.util.RebufferingInputStream;
import com.github.cassandra.jdbc.internal.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;

public class NIODataInputStream
extends RebufferingInputStream {
    protected final ReadableByteChannel channel;

    private static ByteBuffer makeBuffer(int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        buffer.position(0);
        buffer.limit(0);
        return buffer;
    }

    public NIODataInputStream(ReadableByteChannel channel, ByteBuffer buffer) {
        super(buffer);
        Preconditions.checkNotNull(channel);
        this.channel = channel;
    }

    public NIODataInputStream(ReadableByteChannel channel, int bufferSize) {
        this(channel, NIODataInputStream.makeBuffer(bufferSize));
    }

    @Override
    protected void reBuffer() throws IOException {
        Preconditions.checkState(this.buffer.remaining() == 0);
        this.buffer.clear();
        while (this.channel.read(this.buffer) == 0) {
        }
        this.buffer.flip();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        super.close();
    }

    @Override
    public int available() throws IOException {
        if (this.channel instanceof SeekableByteChannel) {
            SeekableByteChannel sbc = (SeekableByteChannel)this.channel;
            long remainder = Math.max(0L, sbc.size() - sbc.position());
            return remainder > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(remainder + (long)this.buffer.remaining());
        }
        return this.buffer.remaining();
    }
}

