/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.io.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthAvailableInputStream
extends FilterInputStream {
    private long remainingBytes;

    public LengthAvailableInputStream(InputStream in, long totalLength) {
        super(in);
        this.remainingBytes = totalLength;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        --this.remainingBytes;
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int length = this.in.read(b);
        this.remainingBytes -= (long)length;
        return length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        this.remainingBytes -= (long)length;
        return length;
    }

    @Override
    public long skip(long n) throws IOException {
        long length = this.in.skip(n);
        this.remainingBytes -= length;
        return length;
    }

    @Override
    public int available() throws IOException {
        return this.remainingBytes <= 0L ? 0 : (this.remainingBytes > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.remainingBytes);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark/Reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

