/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.io.util;

import com.github.cassandra.jdbc.internal.cassandra.config.Config;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.io.compress.CompressedRandomAccessReader;
import com.github.cassandra.jdbc.internal.cassandra.io.compress.CompressedSequentialWriter;
import com.github.cassandra.jdbc.internal.cassandra.io.compress.CompressionMetadata;
import com.github.cassandra.jdbc.internal.cassandra.io.util.ChannelProxy;
import com.github.cassandra.jdbc.internal.cassandra.io.util.ICompressedFile;
import com.github.cassandra.jdbc.internal.cassandra.io.util.MmappedRegions;
import com.github.cassandra.jdbc.internal.cassandra.io.util.RandomAccessReader;
import com.github.cassandra.jdbc.internal.cassandra.io.util.SegmentedFile;
import com.github.cassandra.jdbc.internal.cassandra.utils.JVMStabilityInspector;
import com.github.cassandra.jdbc.internal.cassandra.utils.concurrent.Ref;
import com.github.cassandra.jdbc.internal.google.common.util.concurrent.RateLimiter;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;

public class CompressedSegmentedFile
extends SegmentedFile
implements ICompressedFile {
    private static final Logger logger = LoggerFactory.getLogger(CompressedSegmentedFile.class);
    private static final boolean useMmap = DatabaseDescriptor.getDiskAccessMode() == Config.DiskAccessMode.mmap;
    public final CompressionMetadata metadata;
    private final MmappedRegions regions;

    public CompressedSegmentedFile(ChannelProxy channel, int bufferSize, CompressionMetadata metadata) {
        this(channel, bufferSize, metadata, useMmap ? MmappedRegions.map(channel, metadata) : null);
    }

    public CompressedSegmentedFile(ChannelProxy channel, int bufferSize, CompressionMetadata metadata, MmappedRegions regions) {
        super(new Cleanup(channel, metadata, regions), channel, bufferSize, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
        this.regions = regions;
    }

    private CompressedSegmentedFile(CompressedSegmentedFile copy) {
        super(copy);
        this.metadata = copy.metadata;
        this.regions = copy.regions;
    }

    @Override
    public ChannelProxy channel() {
        return this.channel;
    }

    @Override
    public MmappedRegions regions() {
        return this.regions;
    }

    @Override
    public CompressedSegmentedFile sharedCopy() {
        return new CompressedSegmentedFile(this);
    }

    public void addTo(Ref.IdentityCollection identities) {
        super.addTo(identities);
        this.metadata.addTo(identities);
    }

    @Override
    public void dropPageCache(long before) {
        if (before >= this.metadata.dataLength) {
            super.dropPageCache(0L);
        }
        super.dropPageCache(this.metadata.chunkFor((long)before).offset);
    }

    @Override
    public RandomAccessReader createReader() {
        return new CompressedRandomAccessReader.Builder((ICompressedFile)this).build();
    }

    @Override
    public RandomAccessReader createReader(RateLimiter limiter) {
        return new CompressedRandomAccessReader.Builder((ICompressedFile)this).limiter(limiter).build();
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    public static class Builder
    extends SegmentedFile.Builder {
        final CompressedSequentialWriter writer;

        public Builder(CompressedSequentialWriter writer) {
            this.writer = writer;
        }

        protected CompressionMetadata metadata(String path, long overrideLength) {
            if (this.writer == null) {
                return CompressionMetadata.create((String)path);
            }
            return this.writer.open(overrideLength);
        }

        @Override
        public SegmentedFile complete(ChannelProxy channel, int bufferSize, long overrideLength) {
            return new CompressedSegmentedFile(channel, bufferSize, this.metadata(channel.filePath(), overrideLength));
        }
    }

    private static final class Cleanup
    extends SegmentedFile.Cleanup {
        final CompressionMetadata metadata;
        private final MmappedRegions regions;

        protected Cleanup(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
            super(channel);
            this.metadata = metadata;
            this.regions = regions;
        }

        @Override
        public void tidy() {
            Throwable err;
            Throwable throwable = err = this.regions == null ? null : this.regions.close(null);
            if (err != null) {
                JVMStabilityInspector.inspectThrowable(err);
                logger.error("Error while closing mmapped regions", err);
            }
            this.metadata.close();
            super.tidy();
        }
    }
}

