/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.exceptions;

import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.FunctionName;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ExceptionCode;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import java.util.List;

public class FunctionExecutionException
extends RequestExecutionException {
    public final FunctionName functionName;
    public final List<String> argTypes;
    public final String detail;

    public static FunctionExecutionException create(Function function, Throwable cause) {
        List<String> cqlTypes = AbstractType.asCQLTypeStringList(function.argTypes());
        FunctionExecutionException fee = new FunctionExecutionException(function.name(), cqlTypes, cause.toString());
        fee.initCause(cause);
        return fee;
    }

    public FunctionExecutionException(FunctionName functionName, List<String> argTypes, String detail) {
        super(ExceptionCode.FUNCTION_FAILURE, "execution of '" + functionName + argTypes + "' failed: " + detail);
        this.functionName = functionName;
        this.argTypes = argTypes;
        this.detail = detail;
    }
}

