/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Json;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AsciiType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.UTF8Serializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;

public class UTF8Type
extends AbstractType<String> {
    public static final UTF8Type instance = new UTF8Type();

    UTF8Type() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return this.decompose(source);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a UTF-8 string, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        try {
            return '\"' + Json.quoteAsJsonString(ByteBufferUtil.string(buffer, Charset.forName("UTF-8"))) + '\"';
        }
        catch (CharacterCodingException exc) {
            throw new AssertionError("UTF-8 value contained non-utf8 characters: ", exc);
        }
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this == previous || previous == AsciiType.instance;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TEXT;
    }

    @Override
    public TypeSerializer<String> getSerializer() {
        return UTF8Serializer.instance;
    }
}

