/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.LongType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TimeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import java.nio.ByteBuffer;

public class TimeType
extends AbstractType<Long> {
    public static final TimeType instance = new TimeType();

    private TimeType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        return this.decompose(TimeSerializer.timeStringToLong(source));
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == LongType.instance;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a time value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return '\"' + TimeSerializer.instance.toString(TimeSerializer.instance.deserialize(buffer)) + '\"';
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIME;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return TimeSerializer.instance;
    }
}

