/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.ShortSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class ShortType
extends AbstractType<Short> {
    public static final ShortType instance = new ShortType();

    ShortType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        int diff = o1.get(o1.position()) - o2.get(o2.position());
        if (diff != 0) {
            return diff;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        short s;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            s = Short.parseShort(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("Unable to make short from '%s'", source), e);
        }
        return this.decompose(s);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            Number parsedNumber = (Number)parsed;
            if (!(parsedNumber instanceof Short)) {
                throw new MarshalException(String.format("Expected a short value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(parsedNumber.shortValue()));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a short value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.SMALLINT;
    }

    @Override
    public TypeSerializer<Short> getSerializer() {
        return ShortSerializer.instance;
    }
}

