/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.PartitionPosition;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.TypeParser;
import com.github.cassandra.jdbc.internal.cassandra.dht.IPartitioner;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.cassandra.utils.FBUtilities;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class PartitionerDefinedOrder
extends AbstractType<ByteBuffer> {
    private final IPartitioner partitioner;

    public PartitionerDefinedOrder(IPartitioner partitioner) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.partitioner = partitioner;
    }

    public static AbstractType<?> getInstance(TypeParser parser) {
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        Iterator<String> argIterator = parser.getKeyValueParameters().keySet().iterator();
        if (argIterator.hasNext()) {
            partitioner = FBUtilities.newPartitioner(argIterator.next());
            assert (!argIterator.hasNext());
        }
        return partitioner.partitionOrdering();
    }

    @Override
    public ByteBuffer compose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public ByteBuffer decompose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term fromJSONObject(Object parsed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        return PartitionPosition.ForKey.get((ByteBuffer)o1, (IPartitioner)this.partitioner).compareTo((Object)PartitionPosition.ForKey.get((ByteBuffer)o2, (IPartitioner)this.partitioner));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        throw new IllegalStateException("You shouldn't be validating this.");
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", this.getClass().getName(), this.partitioner.getClass().getName());
    }
}

