/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.UUIDSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.cassandra.utils.UUIDGen;
import java.nio.ByteBuffer;
import java.util.UUID;

public class LexicalUUIDType
extends AbstractType<UUID> {
    public static final LexicalUUIDType instance = new LexicalUUIDType();

    LexicalUUIDType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        return UUIDGen.getUUID(o1).compareTo(UUIDGen.getUUID(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            return this.decompose(UUID.fromString(source));
        }
        catch (IllegalArgumentException e) {
            throw new MarshalException(String.format("unable to make UUID from '%s'", source), e);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a uuid, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public TypeSerializer<UUID> getSerializer() {
        return UUIDSerializer.instance;
    }

    @Override
    protected int valueLengthIfFixed() {
        return 16;
    }
}

