/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.InetAddressSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class InetAddressType
extends AbstractType<InetAddress> {
    public static final InetAddressType instance = new InetAddressType();

    InetAddressType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        InetAddress address;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            address = InetAddress.getByName(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("Unable to make inet address from '%s'", source), e);
        }
        return this.decompose(address);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(instance.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of an inet value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return '\"' + this.getSerializer().deserialize(buffer).getHostAddress() + '\"';
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.INET;
    }

    @Override
    public TypeSerializer<InetAddress> getSerializer() {
        return InetAddressSerializer.instance;
    }
}

