/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.EmptySerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class EmptyType
extends AbstractType<Void> {
    public static final EmptyType instance = new EmptyType();

    private EmptyType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        return 0;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return "";
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (!source.isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", source));
        }
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (!(parsed instanceof String)) {
            throw new MarshalException(String.format("Expected an empty string, but got: %s", parsed));
        }
        if (!((String)parsed).isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", parsed));
        }
        return new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.EMPTY;
    }

    @Override
    public TypeSerializer<Void> getSerializer() {
        return EmptySerializer.instance;
    }

    @Override
    protected int valueLengthIfFixed() {
        return 0;
    }
}

