/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.DoubleSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class DoubleType
extends AbstractType<Double> {
    public static final DoubleType instance = new DoubleType();

    DoubleType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        return ((Double)this.compose(o1)).compareTo((Double)this.compose(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        Double d;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            d = Double.valueOf(source);
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("Unable to make double from '%s'", source), e1);
        }
        return this.decompose(d);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(((Number)parsed).doubleValue()));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a double value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DOUBLE;
    }

    @Override
    public TypeSerializer<Double> getSerializer() {
        return DoubleSerializer.instance;
    }

    @Override
    protected int valueLengthIfFixed() {
        return 8;
    }
}

