/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.DecimalSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class DecimalType
extends AbstractType<BigDecimal> {
    public static final DecimalType instance = new DecimalType();

    DecimalType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        return ((BigDecimal)this.compose(o1)).compareTo((BigDecimal)this.compose(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigDecimal decimal;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            decimal = new BigDecimal(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make BigDecimal from '%s'", source), e);
        }
        return this.decompose(decimal);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.getSerializer().serialize(new BigDecimal(parsed.toString())));
        }
        catch (NumberFormatException exc) {
            throw new MarshalException(String.format("Value '%s' is not a valid representation of a decimal value", parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DECIMAL;
    }

    @Override
    public TypeSerializer<BigDecimal> getSerializer() {
        return DecimalSerializer.instance;
    }
}

