/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Lists;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Maps;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Sets;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.BytesType;
import com.github.cassandra.jdbc.internal.cassandra.db.rows.Cell;
import com.github.cassandra.jdbc.internal.cassandra.db.rows.CellPath;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataInputPlus;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataOutputPlus;
import com.github.cassandra.jdbc.internal.cassandra.serializers.CollectionSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public abstract class CollectionType<T>
extends AbstractType<T> {
    public static CellPath.Serializer cellPathSerializer = new CollectionPathSerializer();
    public final Kind kind;

    protected CollectionType(AbstractType.ComparisonType comparisonType, Kind kind) {
        super(comparisonType);
        this.kind = kind;
    }

    public abstract AbstractType<?> nameComparator();

    public abstract AbstractType<?> valueComparator();

    protected abstract List<ByteBuffer> serializedValues(Iterator<Cell> var1);

    @Override
    public abstract CollectionSerializer<T> getSerializer();

    public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
        return this.kind.makeCollectionReceiver(collection, isKey);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return BytesType.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public void validateCellValue(ByteBuffer cellValue) throws MarshalException {
        if (this.isMultiCell()) {
            this.valueComparator().validateCellValue(cellValue);
        } else {
            super.validateCellValue(cellValue);
        }
    }

    public boolean isMap() {
        return this.kind == Kind.MAP;
    }

    protected int collectionSize(List<ByteBuffer> values) {
        return values.size();
    }

    public ByteBuffer serializeForNativeProtocol(ColumnDefinition def, Iterator<Cell> cells, int version) {
        assert (this.isMultiCell());
        List<ByteBuffer> values = this.serializedValues(cells);
        int size = this.collectionSize(values);
        return CollectionSerializer.pack(values, size, version);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        if (!this.isMultiCell()) {
            return this.isCompatibleWithFrozen(tprev);
        }
        if (!this.nameComparator().isCompatibleWith(tprev.nameComparator())) {
            return false;
        }
        return this.valueComparator().isValueCompatibleWith(tprev.valueComparator());
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> previous) {
        if (this.isMultiCell()) {
            return this.isCompatibleWith(previous);
        }
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        return this.isValueCompatibleWithFrozen(tprev);
    }

    protected abstract boolean isCompatibleWithFrozen(CollectionType<?> var1);

    protected abstract boolean isValueCompatibleWithFrozen(CollectionType<?> var1);

    @Override
    public CQL3Type asCQL3Type() {
        return new CQL3Type.Collection(this);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    private static class CollectionPathSerializer
    implements CellPath.Serializer {
        private CollectionPathSerializer() {
        }

        public void serialize(CellPath path, DataOutputPlus out) throws IOException {
            ByteBufferUtil.writeWithVIntLength(path.get(0), out);
        }

        public CellPath deserialize(DataInputPlus in) throws IOException {
            return CellPath.create((ByteBuffer)ByteBufferUtil.readWithVIntLength(in));
        }

        public long serializedSize(CellPath path) {
            return ByteBufferUtil.serializedSizeWithVIntLength(path.get(0));
        }

        public void skip(DataInputPlus in) throws IOException {
            ByteBufferUtil.skipWithVIntLength(in);
        }
    }

    public static enum Kind {
        MAP{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return isKey ? Maps.keySpecOf(collection) : Maps.valueSpecOf(collection);
            }
        }
        ,
        SET{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return Sets.valueSpecOf(collection);
            }
        }
        ,
        LIST{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return Lists.valueSpecOf(collection);
            }
        };


        public abstract ColumnSpecification makeCollectionReceiver(ColumnSpecification var1, boolean var2);
    }
}

