/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AsciiType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UTF8Type;
import com.github.cassandra.jdbc.internal.cassandra.serializers.BytesSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.cassandra.utils.Hex;
import java.nio.ByteBuffer;

public class BytesType
extends AbstractType<ByteBuffer> {
    public static final BytesType instance = new BytesType();

    BytesType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBuffer.wrap(Hex.hexToBytes(source));
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            String parsedString = (String)parsed;
            if (!parsedString.startsWith("0x")) {
                throw new MarshalException(String.format("String representation of blob is missing 0x prefix: %s", parsedString));
            }
            return new Constants.Value(instance.fromString(parsedString.substring(2)));
        }
        catch (MarshalException | ClassCastException exc) {
            throw new MarshalException(String.format("Value '%s' is not a valid blob representation: %s", parsed, exc.getMessage()));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return "\"0x" + ByteBufferUtil.bytesToHex(buffer) + '\"';
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this == previous || previous == AsciiType.instance || previous == UTF8Type.instance;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return true;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BLOB;
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return BytesSerializer.instance;
    }
}

