/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.db.marshal;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.serializers.BooleanSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.TypeSerializer;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import java.nio.ByteBuffer;

public class BooleanType
extends AbstractType<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(BooleanType.class);
    public static final BooleanType instance = new BooleanType();

    BooleanType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        byte b1 = o1.get(o1.position());
        byte b2 = o2.get(o2.position());
        if (b1 == 0) {
            return b2 == 0 ? 0 : -1;
        }
        return b2 == 0 ? 1 : 0;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty() || source.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return this.decompose(false);
        }
        if (source.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return this.decompose(true);
        }
        throw new MarshalException(String.format("Unable to make boolean from '%s'", source));
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            return new Constants.Value(this.fromString((String)parsed));
        }
        if (!(parsed instanceof Boolean)) {
            throw new MarshalException(String.format("Expected a boolean value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        return new Constants.Value(this.getSerializer().serialize((Boolean)parsed));
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BOOLEAN;
    }

    @Override
    public TypeSerializer<Boolean> getSerializer() {
        return BooleanSerializer.instance;
    }

    @Override
    protected int valueLengthIfFixed() {
        return 1;
    }
}

