/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.db.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.cassandra.db.CounterMutation;
import com.github.cassandra.jdbc.internal.cassandra.db.DecoratedKey;
import com.github.cassandra.jdbc.internal.cassandra.db.IMutation;
import com.github.cassandra.jdbc.internal.cassandra.db.Keyspace;
import com.github.cassandra.jdbc.internal.cassandra.db.Mutation;
import com.github.cassandra.jdbc.internal.cassandra.db.PartitionColumns;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.PartitionUpdate;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class UpdatesCollector {
    private final Map<UUID, PartitionColumns> updatedColumns;
    private final int updatedRows;
    private final Map<String, Map<ByteBuffer, IMutation>> mutations = new HashMap<String, Map<ByteBuffer, IMutation>>();

    public UpdatesCollector(Map<UUID, PartitionColumns> updatedColumns, int updatedRows) {
        this.updatedColumns = updatedColumns;
        this.updatedRows = updatedRows;
    }

    public PartitionUpdate getPartitionUpdate(CFMetaData cfm, DecoratedKey dk, ConsistencyLevel consistency) {
        Mutation mut = this.getMutation(cfm, dk, consistency);
        PartitionUpdate upd = mut.get(cfm);
        if (upd == null) {
            PartitionColumns columns = this.updatedColumns.get(cfm.cfId);
            assert (columns != null);
            upd = new PartitionUpdate(cfm, dk, columns, this.updatedRows);
            mut.add(upd);
        }
        return upd;
    }

    public void validateIndexedColumns() {
        for (Map<ByteBuffer, IMutation> perKsMutations : this.mutations.values()) {
            for (IMutation mutation : perKsMutations.values()) {
                for (PartitionUpdate update : mutation.getPartitionUpdates()) {
                    Keyspace.openAndGetStore((CFMetaData)update.metadata()).indexManager.validate(update);
                }
            }
        }
    }

    private Mutation getMutation(CFMetaData cfm, DecoratedKey dk, ConsistencyLevel consistency) {
        String ksName = cfm.ksName;
        IMutation mutation = this.keyspaceMap(ksName).get(dk.getKey());
        if (mutation == null) {
            Mutation mut = new Mutation(ksName, dk);
            mutation = cfm.isCounter() ? new CounterMutation(mut, consistency) : mut;
            this.keyspaceMap(ksName).put(dk.getKey(), mutation);
            return mut;
        }
        return cfm.isCounter() ? ((CounterMutation)mutation).getMutation() : (Mutation)mutation;
    }

    public Collection<IMutation> toMutations() {
        if (this.mutations.size() == 1) {
            return this.mutations.values().iterator().next().values();
        }
        ArrayList<IMutation> ms = new ArrayList<IMutation>();
        for (Map<ByteBuffer, IMutation> ksMap : this.mutations.values()) {
            ms.addAll(ksMap.values());
        }
        return ms;
    }

    private Map<ByteBuffer, IMutation> keyspaceMap(String ksName) {
        Map<ByteBuffer, IMutation> ksMap = this.mutations.get(ksName);
        if (ksMap == null) {
            ksMap = new HashMap<ByteBuffer, IMutation>();
            this.mutations.put(ksName, ksMap);
        }
        return ksMap;
    }
}

