/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Attributes;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnCondition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Conditions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Json;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operations;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operator;
import com.github.cassandra.jdbc.internal.cassandra.cql3.SingleColumnRelation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UpdateParameters;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.WhereClause;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.StatementRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ModificationStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.RequestValidations;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.StatementType;
import com.github.cassandra.jdbc.internal.cassandra.db.Clustering;
import com.github.cassandra.jdbc.internal.cassandra.db.CompactTables;
import com.github.cassandra.jdbc.internal.cassandra.db.Slice;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.PartitionUpdate;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.cassandra.utils.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UpdateStatement
extends ModificationStatement {
    private static final Constants.Value EMPTY = new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);

    private UpdateStatement(StatementType type, int boundTerms, CFMetaData cfm, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        super(type, boundTerms, cfm, operations, restrictions, conditions, attrs);
    }

    public boolean requireFullClusteringKey() {
        return true;
    }

    @Override
    public void addUpdateForKey(PartitionUpdate update, Clustering clustering, UpdateParameters params) {
        if (this.updatesRegularRows()) {
            params.newRow(clustering);
            if (this.type.isInsert() && this.cfm.isCQLTable()) {
                params.addPrimaryKeyLivenessInfo();
            }
            List<Operation> updates = this.getRegularOperations();
            if (this.cfm.isCompactTable() && updates.isEmpty()) {
                RequestValidations.checkTrue(CompactTables.hasEmptyCompactValue((CFMetaData)this.cfm), "Column %s is mandatory for this COMPACT STORAGE table", this.cfm.compactValueColumn().name);
                updates = Collections.singletonList(new Constants.Setter(this.cfm.compactValueColumn(), EMPTY));
            }
            for (Operation op : updates) {
                op.execute(update.partitionKey(), params);
            }
            update.add(params.buildRow());
        }
        if (this.updatesStaticRow()) {
            params.newRow(Clustering.STATIC_CLUSTERING);
            for (Operation op : this.getStaticOperations()) {
                op.execute(update.partitionKey(), params);
            }
            update.add(params.buildRow());
        }
    }

    @Override
    public void addUpdateForKey(PartitionUpdate update, Slice slice, UpdateParameters params) {
        throw new UnsupportedOperationException();
    }

    public static class ParsedUpdate
    extends ModificationStatement.Parsed {
        private final List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> updates;
        private final WhereClause whereClause;

        public ParsedUpdate(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> updates, WhereClause whereClause, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, StatementType.UPDATE, attrs, conditions, false, ifExists);
            this.updates = updates;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Conditions conditions, Attributes attrs) {
            Operations operations = new Operations(this.type);
            for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> entry : this.updates) {
                ColumnDefinition def = ParsedUpdate.getColumnDefinition(cfm, (ColumnIdentifier.Raw)entry.left);
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "PRIMARY KEY part %s found in SET part", def.name);
                Operation operation = ((Operation.RawUpdate)entry.right).prepare(this.keyspace(), def);
                operation.collectMarkerSpecification(boundNames);
                operations.add(operation);
            }
            StatementRestrictions restrictions = this.newRestrictions(cfm, boundNames, operations, this.whereClause, conditions);
            return new UpdateStatement(this.type, boundNames.size(), cfm, operations, restrictions, conditions, attrs);
        }
    }

    public static class ParsedInsertJson
    extends ModificationStatement.Parsed {
        private final Json.Raw jsonValue;

        public ParsedInsertJson(CFName name, Attributes.Raw attrs, Json.Raw jsonValue, boolean ifNotExists) {
            super(name, StatementType.INSERT, attrs, null, ifNotExists, false);
            this.jsonValue = jsonValue;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Conditions conditions, Attributes attrs) {
            RequestValidations.checkFalse(cfm.isCounter(), "INSERT statements are not allowed on counter tables, use UPDATE instead");
            Collection<ColumnDefinition> defs = cfm.allColumns();
            Json.Prepared prepared = this.jsonValue.prepareAndCollectMarkers(cfm, defs, boundNames);
            WhereClause.Builder whereClause = new WhereClause.Builder();
            Operations operations = new Operations(this.type);
            boolean hasClusteringColumnsSet = false;
            for (ColumnDefinition def : defs) {
                if (def.isClusteringColumn()) {
                    hasClusteringColumnsSet = true;
                }
                Term.Raw raw = prepared.getRawTermForColumn(def);
                if (def.isPrimaryKeyColumn()) {
                    whereClause.add(new SingleColumnRelation(new ColumnIdentifier.ColumnIdentifierValue(def.name), Operator.EQ, raw));
                    continue;
                }
                Operation operation = new Operation.SetValue(raw).prepare(this.keyspace(), def);
                operation.collectMarkerSpecification(boundNames);
                operations.add(operation);
            }
            boolean applyOnlyToStaticColumns = ModificationStatement.appliesOnlyToStaticColumns(operations, conditions) && !hasClusteringColumnsSet;
            StatementRestrictions restrictions = new StatementRestrictions(this.type, cfm, whereClause.build(), boundNames, applyOnlyToStaticColumns, false, false, false);
            return new UpdateStatement(this.type, boundNames.size(), cfm, operations, restrictions, conditions, attrs);
        }
    }

    public static class ParsedInsert
    extends ModificationStatement.Parsed {
        private final List<ColumnIdentifier.Raw> columnNames;
        private final List<Term.Raw> columnValues;

        public ParsedInsert(CFName name, Attributes.Raw attrs, List<ColumnIdentifier.Raw> columnNames, List<Term.Raw> columnValues, boolean ifNotExists) {
            super(name, StatementType.INSERT, attrs, null, ifNotExists, false);
            this.columnNames = columnNames;
            this.columnValues = columnValues;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Conditions conditions, Attributes attrs) {
            RequestValidations.checkFalse(cfm.isCounter(), "INSERT statements are not allowed on counter tables, use UPDATE instead");
            RequestValidations.checkFalse(this.columnNames == null, "Column names for INSERT must be provided when using VALUES");
            RequestValidations.checkFalse(this.columnNames.isEmpty(), "No columns provided to INSERT");
            RequestValidations.checkFalse(this.columnNames.size() != this.columnValues.size(), "Unmatched column names/values");
            RequestValidations.checkContainsNoDuplicates(this.columnNames, "The column names contains duplicates");
            WhereClause.Builder whereClause = new WhereClause.Builder();
            Operations operations = new Operations(this.type);
            boolean hasClusteringColumnsSet = false;
            for (int i = 0; i < this.columnNames.size(); ++i) {
                ColumnDefinition def = ParsedInsert.getColumnDefinition(cfm, this.columnNames.get(i));
                if (def.isClusteringColumn()) {
                    hasClusteringColumnsSet = true;
                }
                Term.Raw value = this.columnValues.get(i);
                if (def.isPrimaryKeyColumn()) {
                    whereClause.add(new SingleColumnRelation(this.columnNames.get(i), Operator.EQ, value));
                    continue;
                }
                Operation operation = new Operation.SetValue(value).prepare(this.keyspace(), def);
                operation.collectMarkerSpecification(boundNames);
                operations.add(operation);
            }
            boolean applyOnlyToStaticColumns = ModificationStatement.appliesOnlyToStaticColumns(operations, conditions) && !hasClusteringColumnsSet;
            StatementRestrictions restrictions = new StatementRestrictions(this.type, cfm, whereClause.build(), boundNames, applyOnlyToStaticColumns, false, false, false);
            return new UpdateStatement(this.type, boundNames.size(), cfm, operations, restrictions, conditions, attrs);
        }
    }
}

