/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQLStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.CFStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.ColumnFamilyStore;
import com.github.cassandra.jdbc.internal.cassandra.db.Keyspace;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.TruncateException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnavailableException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.service.StorageProxy;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class TruncateStatement
extends CFStatement
implements CQLStatement {
    public TruncateStatement(CFName name) {
        super(name);
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        ThriftValidation.validateColumnFamily((String)this.keyspace(), (String)this.columnFamily());
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws InvalidRequestException, TruncateException {
        try {
            CFMetaData metaData = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily());
            if (metaData.isView()) {
                throw new InvalidRequestException("Cannot TRUNCATE materialized view directly; must truncate base table instead");
            }
            StorageProxy.truncateBlocking((String)this.keyspace(), (String)this.columnFamily());
        }
        catch (UnavailableException | IOException | TimeoutException e) {
            throw new TruncateException(e);
        }
        return null;
    }

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        try {
            ColumnFamilyStore cfs = Keyspace.open((String)this.keyspace()).getColumnFamilyStore(this.columnFamily());
            cfs.truncateBlocking();
        }
        catch (Exception e) {
            throw new TruncateException(e);
        }
        return null;
    }
}

