/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CQLStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import java.util.Collections;
import java.util.List;

public abstract class ParsedStatement {
    private VariableSpecifications variables;

    public VariableSpecifications getBoundVariables() {
        return this.variables;
    }

    public void setBoundVariables(List<ColumnIdentifier> boundNames) {
        this.variables = new VariableSpecifications(boundNames);
    }

    public void setBoundVariables(VariableSpecifications variables) {
        this.variables = variables;
    }

    public abstract Prepared prepare() throws RequestValidationException;

    public Iterable<Function> getFunctions() {
        return Collections.emptyList();
    }

    public static class Prepared {
        public final CQLStatement statement;
        public final List<ColumnSpecification> boundNames;
        public final Short[] partitionKeyBindIndexes;

        protected Prepared(CQLStatement statement, List<ColumnSpecification> boundNames, Short[] partitionKeyBindIndexes) {
            this.statement = statement;
            this.boundNames = boundNames;
            this.partitionKeyBindIndexes = partitionKeyBindIndexes;
        }

        public Prepared(CQLStatement statement, VariableSpecifications names, Short[] partitionKeyBindIndexes) {
            this(statement, names.getSpecifications(), partitionKeyBindIndexes);
        }

        public Prepared(CQLStatement statement) {
            this(statement, Collections.emptyList(), null);
        }
    }
}

