/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.config.ViewDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Attributes;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQLStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnCondition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnConditions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Conditions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operations;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryProcessor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ResultSet;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UpdateParameters;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.WhereClause;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.StatementRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.Selection;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.Bound;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.CFStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.CQL3CasRequest;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.RequestValidations;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SelectStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.StatementType;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.UpdatesCollector;
import com.github.cassandra.jdbc.internal.cassandra.db.CBuilder;
import com.github.cassandra.jdbc.internal.cassandra.db.Clustering;
import com.github.cassandra.jdbc.internal.cassandra.db.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.cassandra.db.DecoratedKey;
import com.github.cassandra.jdbc.internal.cassandra.db.IMutation;
import com.github.cassandra.jdbc.internal.cassandra.db.PartitionColumns;
import com.github.cassandra.jdbc.internal.cassandra.db.ReadExecutionController;
import com.github.cassandra.jdbc.internal.cassandra.db.SinglePartitionReadCommand;
import com.github.cassandra.jdbc.internal.cassandra.db.Slice;
import com.github.cassandra.jdbc.internal.cassandra.db.Slices;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.ClusteringIndexFilter;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.ClusteringIndexNamesFilter;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.ClusteringIndexSliceFilter;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.DataLimits;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.BooleanType;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.FilteredPartition;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.Partition;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.PartitionIterator;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.PartitionIterators;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.PartitionUpdate;
import com.github.cassandra.jdbc.internal.cassandra.db.rows.RowIterator;
import com.github.cassandra.jdbc.internal.cassandra.db.view.View;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.service.CASRequest;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.service.StorageProxy;
import com.github.cassandra.jdbc.internal.cassandra.service.paxos.Commit;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;
import com.github.cassandra.jdbc.internal.cassandra.triggers.TriggerExecutor;
import com.github.cassandra.jdbc.internal.cassandra.utils.FBUtilities;
import com.github.cassandra.jdbc.internal.cassandra.utils.Pair;
import com.github.cassandra.jdbc.internal.cassandra.utils.UUIDGen;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.UUID;

public abstract class ModificationStatement
implements CQLStatement {
    protected static final Logger logger = LoggerFactory.getLogger(ModificationStatement.class);
    public static final String CUSTOM_EXPRESSIONS_NOT_ALLOWED = "Custom index expressions cannot be used in WHERE clauses for UPDATE or DELETE statements";
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    protected final StatementType type;
    private final int boundTerms;
    public final CFMetaData cfm;
    private final Attributes attrs;
    private final StatementRestrictions restrictions;
    private final Operations operations;
    private final PartitionColumns updatedColumns;
    private final Conditions conditions;
    private final PartitionColumns conditionColumns;
    private final PartitionColumns requiresRead;

    public ModificationStatement(StatementType type, int boundTerms, CFMetaData cfm, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        this.type = type;
        this.boundTerms = boundTerms;
        this.cfm = cfm;
        this.restrictions = restrictions;
        this.operations = operations;
        this.conditions = conditions;
        this.attrs = attrs;
        if (!conditions.isEmpty()) {
            RequestValidations.checkFalse(cfm.isCounter(), "Conditional updates are not supported on counter tables");
            RequestValidations.checkFalse(attrs.isTimestampSet(), "Cannot provide custom timestamp for conditional updates");
        }
        PartitionColumns.Builder conditionColumnsBuilder = PartitionColumns.builder();
        Iterable<ColumnDefinition> columns = conditions.getColumns();
        if (columns != null) {
            conditionColumnsBuilder.addAll(columns);
        }
        PartitionColumns.Builder updatedColumnsBuilder = PartitionColumns.builder();
        PartitionColumns.Builder requiresReadBuilder = PartitionColumns.builder();
        for (Operation operation : operations) {
            updatedColumnsBuilder.add(operation.column);
            if (!operation.requiresRead()) continue;
            conditionColumnsBuilder.add(operation.column);
            requiresReadBuilder.add(operation.column);
        }
        PartitionColumns modifiedColumns = updatedColumnsBuilder.build();
        if (cfm.isCompactTable() && modifiedColumns.isEmpty() && this.updatesRegularRows()) {
            modifiedColumns = cfm.partitionColumns();
        }
        this.updatedColumns = modifiedColumns;
        this.conditionColumns = conditionColumnsBuilder.build();
        this.requiresRead = requiresReadBuilder.build();
    }

    @Override
    public Iterable<Function> getFunctions() {
        return Iterables.concat(this.attrs.getFunctions(), this.restrictions.getFunctions(), this.operations.getFunctions(), this.conditions.getFunctions());
    }

    public abstract void addUpdateForKey(PartitionUpdate var1, Clustering var2, UpdateParameters var3);

    public abstract void addUpdateForKey(PartitionUpdate var1, Slice var2, UpdateParameters var3);

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public boolean isCounter() {
        return this.cfm.isCounter();
    }

    public boolean isView() {
        return this.cfm.isView();
    }

    public long getTimestamp(long now, QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, options);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimeToLive(options);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        Iterator views;
        state.hasColumnFamilyAccess(this.cfm, Permission.MODIFY);
        if (this.hasConditions()) {
            state.hasColumnFamilyAccess(this.cfm, Permission.SELECT);
        }
        if ((views = View.findAll((String)this.keyspace(), (String)this.columnFamily()).iterator()).hasNext()) {
            state.hasColumnFamilyAccess(this.cfm, Permission.SELECT);
            do {
                state.hasColumnFamilyAccess(((ViewDefinition)views.next()).metadata, Permission.MODIFY);
            } while (views.hasNext());
        }
        for (Function function : this.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        RequestValidations.checkFalse(this.hasConditions() && this.attrs.isTimestampSet(), "Cannot provide custom timestamp for conditional updates");
        RequestValidations.checkFalse(this.isCounter() && this.attrs.isTimestampSet(), "Cannot provide custom timestamp for counter updates");
        RequestValidations.checkFalse(this.isCounter() && this.attrs.isTimeToLiveSet(), "Cannot provide custom TTL for counter updates");
        RequestValidations.checkFalse(this.isView(), "Cannot directly modify a materialized view");
    }

    public PartitionColumns updatedColumns() {
        return this.updatedColumns;
    }

    public PartitionColumns conditionColumns() {
        return this.conditionColumns;
    }

    public boolean updatesRegularRows() {
        return this.cfm.clusteringColumns().isEmpty() || this.restrictions.hasClusteringColumnsRestriction();
    }

    public boolean updatesStaticRow() {
        return this.operations.appliesToStaticColumns();
    }

    public List<Operation> getRegularOperations() {
        return this.operations.regularOperations();
    }

    public List<Operation> getStaticOperations() {
        return this.operations.staticOperations();
    }

    public Iterable<Operation> allOperations() {
        return this.operations;
    }

    public Iterable<ColumnDefinition> getColumnsWithConditions() {
        return this.conditions.getColumns();
    }

    public boolean hasIfNotExistCondition() {
        return this.conditions.isIfNotExists();
    }

    public boolean hasIfExistCondition() {
        return this.conditions.isIfExists();
    }

    public List<ByteBuffer> buildPartitionKeyNames(QueryOptions options) throws InvalidRequestException {
        List<ByteBuffer> partitionKeys = this.restrictions.getPartitionKeys(options);
        for (ByteBuffer key : partitionKeys) {
            QueryProcessor.validateKey(key);
        }
        return partitionKeys;
    }

    public NavigableSet<Clustering> createClustering(QueryOptions options) throws InvalidRequestException {
        if (this.appliesOnlyToStaticColumns() && !this.restrictions.hasClusteringColumnsRestriction()) {
            return FBUtilities.singleton(CBuilder.STATIC_BUILDER.build(), this.cfm.comparator);
        }
        return this.restrictions.getClusteringColumns(options);
    }

    private boolean appliesOnlyToStaticColumns() {
        return ModificationStatement.appliesOnlyToStaticColumns(this.operations, this.conditions);
    }

    public static boolean appliesOnlyToStaticColumns(Operations operation, Conditions conditions) {
        return !operation.appliesToRegularColumns() && !conditions.appliesToRegularColumns() && (operation.appliesToStaticColumns() || conditions.appliesToStaticColumns());
    }

    public boolean requiresRead() {
        for (Operation op : this.allOperations()) {
            if (!op.requiresRead()) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private Map<DecoratedKey, Partition> readRequiredLists(Collection<ByteBuffer> partitionKeys, ClusteringIndexFilter filter, DataLimits limits, boolean local, ConsistencyLevel cl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<DecoratedKey, Partition> asMaterializedMap(PartitionIterator iterator) {
        HashMap<DecoratedKey, Partition> map = new HashMap<DecoratedKey, Partition>();
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                map.put(partition.partitionKey(), (Partition)FilteredPartition.create((RowIterator)partition));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
        return map;
    }

    public boolean hasConditions() {
        return !this.conditions.isEmpty();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        return this.hasConditions() ? this.executeWithCondition(queryState, options) : this.executeWithoutCondition(queryState, options);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.cfm);
        } else {
            cl.validateForWrite(this.cfm.ksName);
        }
        Collection<? extends IMutation> mutations = this.getMutations(options, false, options.getTimestamp(queryState));
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, (ConsistencyLevel)cl, (boolean)false);
        }
        return null;
    }

    public ResultMessage executeWithCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        CQL3CasRequest request = this.makeCasRequest(queryState, options);
        try (RowIterator result = StorageProxy.cas((String)this.keyspace(), (String)this.columnFamily(), (DecoratedKey)request.key, (CASRequest)request, (ConsistencyLevel)options.getSerialConsistency(), (ConsistencyLevel)options.getConsistency(), (ClientState)queryState.getClientState());){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, options));
            return rows;
        }
    }

    private CQL3CasRequest makeCasRequest(QueryState queryState, QueryOptions options) {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        RequestValidations.checkFalse(keys.size() > 1, "IN on the partition key is not supported with conditional %s", this.type.isUpdate() ? "updates" : "deletions");
        DecoratedKey key = this.cfm.decorateKey(keys.get(0));
        long now = options.getTimestamp(queryState);
        NavigableSet<Clustering> clusterings = this.createClustering(options);
        RequestValidations.checkFalse(clusterings.size() > 1, "IN on the clustering key columns is not supported with conditional %s", this.type.isUpdate() ? "updates" : "deletions");
        Clustering clustering = Iterables.getOnlyElement(clusterings);
        CQL3CasRequest request = new CQL3CasRequest(this.cfm, key, false, this.conditionColumns(), this.updatesRegularRows(), this.updatesStaticRow());
        this.addConditions(clustering, request, options);
        request.addRowUpdate(clustering, this, options, now);
        return request;
    }

    public void addConditions(Clustering clustering, CQL3CasRequest request, QueryOptions options) throws InvalidRequestException {
        this.conditions.addConditionsTo(request, clustering, options);
    }

    private ResultSet buildCasResultSet(RowIterator partition, QueryOptions options) throws InvalidRequestException {
        return ModificationStatement.buildCasResultSet(this.keyspace(), this.columnFamily(), partition, this.getColumnsWithConditions(), false, options);
    }

    public static ResultSet buildCasResultSet(String ksName, String tableName, RowIterator partition, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        boolean success = partition == null;
        ColumnSpecification spec = new ColumnSpecification(ksName, tableName, CAS_RESULT_COLUMN, BooleanType.instance);
        ResultSet.ResultMetadata metadata = new ResultSet.ResultMetadata(Collections.singletonList(spec));
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, ModificationStatement.buildCasFailureResultSet(partition, columnsWithConditions, isBatch, options));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList<List<ByteBuffer>> rows = new ArrayList<List<ByteBuffer>>(right.size());
        for (int i = 0; i < right.size(); ++i) {
            ArrayList row = new ArrayList(size);
            row.addAll(left.rows.get(0));
            row.addAll(right.rows.get(i));
            rows.add(row);
        }
        return new ResultSet(new ResultSet.ResultMetadata(specs), rows);
    }

    private static ResultSet buildCasFailureResultSet(RowIterator partition, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        Selection selection;
        CFMetaData cfm = partition.metadata();
        if (columnsWithConditions == null) {
            selection = Selection.wildcard(cfm);
        } else {
            LinkedHashSet<ColumnDefinition> defs = new LinkedHashSet<ColumnDefinition>();
            if (isBatch) {
                defs.addAll(cfm.partitionKeyColumns());
                defs.addAll(cfm.clusteringColumns());
            }
            for (ColumnDefinition def : columnsWithConditions) {
                defs.add(def);
            }
            selection = Selection.forColumns(cfm, new ArrayList<ColumnDefinition>(defs));
        }
        Selection.ResultSetBuilder builder = selection.resultSetBuilder(false);
        SelectStatement.forSelection(cfm, selection).processPartition(partition, options, builder, FBUtilities.nowInSeconds());
        return builder.build(options.getProtocolVersion());
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        return this.hasConditions() ? this.executeInternalWithCondition(queryState, options) : this.executeInternalWithoutCondition(queryState, options);
    }

    public ResultMessage executeInternalWithoutCondition(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(options, true, queryState.getTimestamp())) {
            iMutation.apply();
        }
        return null;
    }

    public ResultMessage executeInternalWithCondition(QueryState state, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        CQL3CasRequest request = this.makeCasRequest(state, options);
        try (RowIterator result = ModificationStatement.casInternal(request, state);){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, options));
            return rows;
        }
    }

    /*
     * WARNING - void declaration
     */
    static RowIterator casInternal(CQL3CasRequest request, QueryState state) {
        void var8_10;
        FilteredPartition current;
        UUID ballot = UUIDGen.getTimeUUIDFromMicros(state.getTimestamp());
        SinglePartitionReadCommand readCommand = request.readCommand(FBUtilities.nowInSeconds());
        try (ReadExecutionController executionController = readCommand.executionController();
             PartitionIterator iter = readCommand.executeInternal(executionController);){
            current = FilteredPartition.create((RowIterator)PartitionIterators.getOnlyElement((PartitionIterator)iter, (SinglePartitionReadCommand)readCommand));
        }
        if (!request.appliesTo(current)) {
            return current.rowIterator();
        }
        PartitionUpdate updates = request.makeUpdates((FilteredPartition)var8_10);
        updates = TriggerExecutor.instance.execute(updates);
        Commit proposal = Commit.newProposal((UUID)ballot, (PartitionUpdate)updates);
        proposal.makeMutation().apply();
        return null;
    }

    private Collection<? extends IMutation> getMutations(QueryOptions options, boolean local, long now) {
        UpdatesCollector collector = new UpdatesCollector(Collections.singletonMap(this.cfm.cfId, this.updatedColumns), 1);
        this.addUpdates(collector, options, local, now);
        collector.validateIndexedColumns();
        return collector.toMutations();
    }

    final void addUpdates(UpdatesCollector collector, QueryOptions options, boolean local, long now) {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        if (this.type.allowClusteringColumnSlices() && this.restrictions.hasClusteringColumnsRestriction() && this.restrictions.isColumnRange()) {
            Slices slices = this.createSlice(options);
            if (slices.isEmpty()) {
                return;
            }
            UpdateParameters params = this.makeUpdateParameters(keys, (ClusteringIndexFilter)new ClusteringIndexSliceFilter(slices, false), options, DataLimits.NONE, local, now);
            for (ByteBuffer key : keys) {
                ThriftValidation.validateKey((CFMetaData)this.cfm, (ByteBuffer)key);
                DecoratedKey dk = this.cfm.decorateKey(key);
                PartitionUpdate upd = collector.getPartitionUpdate(this.cfm, dk, options.getConsistency());
                for (Slice slice : slices) {
                    this.addUpdateForKey(upd, slice, params);
                }
            }
        } else {
            NavigableSet<Clustering> clusterings = this.createClustering(options);
            UpdateParameters params = this.makeUpdateParameters(keys, clusterings, options, local, now);
            for (ByteBuffer key : keys) {
                ThriftValidation.validateKey((CFMetaData)this.cfm, (ByteBuffer)key);
                DecoratedKey dk = this.cfm.decorateKey(key);
                PartitionUpdate upd = collector.getPartitionUpdate(this.cfm, dk, options.getConsistency());
                if (clusterings.isEmpty()) {
                    this.addUpdateForKey(upd, Clustering.EMPTY, params);
                    continue;
                }
                for (Clustering clustering : clusterings) {
                    this.addUpdateForKey(upd, clustering, params);
                }
            }
        }
    }

    private Slices createSlice(QueryOptions options) {
        NavigableSet<Slice.Bound> startBounds = this.restrictions.getClusteringColumnsBounds(Bound.START, options);
        NavigableSet<Slice.Bound> endBounds = this.restrictions.getClusteringColumnsBounds(Bound.END, options);
        return this.toSlices(startBounds, endBounds);
    }

    private UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, NavigableSet<Clustering> clusterings, QueryOptions options, boolean local, long now) {
        if (clusterings.contains(Clustering.STATIC_CLUSTERING)) {
            return this.makeUpdateParameters(keys, (ClusteringIndexFilter)new ClusteringIndexSliceFilter(Slices.ALL, false), options, DataLimits.cqlLimits((int)1), local, now);
        }
        return this.makeUpdateParameters(keys, (ClusteringIndexFilter)new ClusteringIndexNamesFilter(clusterings, false), options, DataLimits.NONE, local, now);
    }

    private UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, ClusteringIndexFilter filter, QueryOptions options, DataLimits limits, boolean local, long now) {
        Map<DecoratedKey, Partition> lists = this.readRequiredLists(keys, filter, limits, local, options.getConsistency());
        return new UpdateParameters(this.cfm, this.updatedColumns(), options, this.getTimestamp(now, options), this.getTimeToLive(options), lists);
    }

    private Slices toSlices(SortedSet<Slice.Bound> startBounds, SortedSet<Slice.Bound> endBounds) {
        assert (startBounds.size() == endBounds.size());
        Slices.Builder builder = new Slices.Builder(this.cfm.comparator);
        Iterator starts = startBounds.iterator();
        Iterator ends = endBounds.iterator();
        while (starts.hasNext()) {
            Slice slice = Slice.make((Slice.Bound)((Slice.Bound)starts.next()), (Slice.Bound)((Slice.Bound)ends.next()));
            if (slice.isEmpty(this.cfm.comparator)) continue;
            builder.add(slice);
        }
        return builder.build();
    }

    public static abstract class Parsed
    extends CFStatement {
        protected final StatementType type;
        private final Attributes.Raw attrs;
        private final List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions;
        private final boolean ifNotExists;
        private final boolean ifExists;

        protected Parsed(CFName name, StatementType type, Attributes.Raw attrs, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifNotExists, boolean ifExists) {
            super(name);
            this.type = type;
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
            this.ifExists = ifExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() {
            VariableSpecifications boundNames = this.getBoundVariables();
            ModificationStatement statement = this.prepare(boundNames);
            CFMetaData cfm = ThriftValidation.validateColumnFamily((String)this.keyspace(), (String)this.columnFamily());
            return new ParsedStatement.Prepared((CQLStatement)statement, boundNames, boundNames.getPartitionKeyBindIndexes(cfm));
        }

        public ModificationStatement prepare(VariableSpecifications boundNames) {
            CFMetaData metadata = ThriftValidation.validateColumnFamily((String)this.keyspace(), (String)this.columnFamily());
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.columnFamily());
            preparedAttributes.collectMarkerSpecification(boundNames);
            Conditions preparedConditions = this.prepareConditions(metadata, boundNames);
            return this.prepareInternal(metadata, boundNames, preparedConditions, preparedAttributes);
        }

        private Conditions prepareConditions(CFMetaData metadata, VariableSpecifications boundNames) {
            if (this.ifExists) {
                assert (this.conditions.isEmpty());
                assert (!this.ifNotExists);
                return Conditions.IF_EXISTS_CONDITION;
            }
            if (this.ifNotExists) {
                assert (this.conditions.isEmpty());
                assert (!this.ifExists);
                return Conditions.IF_NOT_EXISTS_CONDITION;
            }
            if (this.conditions.isEmpty()) {
                return Conditions.EMPTY_CONDITION;
            }
            return this.prepareColumnConditions(metadata, boundNames);
        }

        private ColumnConditions prepareColumnConditions(CFMetaData metadata, VariableSpecifications boundNames) {
            RequestValidations.checkNull(this.attrs.timestamp, "Cannot provide custom timestamp for conditional updates");
            ColumnConditions.Builder builder = ColumnConditions.newBuilder();
            for (Pair<ColumnIdentifier.Raw, ColumnCondition.Raw> entry : this.conditions) {
                ColumnIdentifier id = ((ColumnIdentifier.Raw)entry.left).prepare(metadata);
                ColumnDefinition def = metadata.getColumnDefinition(id);
                RequestValidations.checkNotNull(metadata.getColumnDefinition(id), "Unknown identifier %s in IF conditions", id);
                ColumnCondition condition = ((ColumnCondition.Raw)entry.right).prepare(this.keyspace(), def);
                condition.collectMarkerSpecification(boundNames);
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "PRIMARY KEY column '%s' cannot have IF conditions", id);
                builder.add(condition);
            }
            return builder.build();
        }

        protected abstract ModificationStatement prepareInternal(CFMetaData var1, VariableSpecifications var2, Conditions var3, Attributes var4);

        protected StatementRestrictions newRestrictions(CFMetaData cfm, VariableSpecifications boundNames, Operations operations, WhereClause where, Conditions conditions) {
            if (where.containsCustomExpressions()) {
                throw new InvalidRequestException(ModificationStatement.CUSTOM_EXPRESSIONS_NOT_ALLOWED);
            }
            boolean applyOnlyToStaticColumns = ModificationStatement.appliesOnlyToStaticColumns(operations, conditions);
            return new StatementRestrictions(this.type, cfm, where, boundNames, applyOnlyToStaticColumns, false, false, false);
        }

        protected static ColumnDefinition getColumnDefinition(CFMetaData cfm, ColumnIdentifier.Raw rawId) {
            ColumnIdentifier id = rawId.prepare(cfm);
            return RequestValidations.checkNotNull(cfm.getColumnDefinition(id), "Unknown identifier %s", id);
        }
    }
}

